/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>

//KDE includes
#include <klocale.h>
#include <kactioncollection.h>
#include <kbuttonbox.h>
#include <klistbox.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kiconloader.h>

#include <kdebug.h>

//Project includes
#include "kernelOptions.h"
#include "ksystemlogConfig.h"

KernelOptions::KernelOptions(QWidget *parent) : 
	QWidget(parent) 
	{
	
	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->setAutoAdd(true);

	QString description= i18n("<qt><p>These files will be analyzed to display <b>Kernel logs</b>. This list also determines the order in which the files are read.</p></qt>");
	fileList=new SpecificFileList(this, description);
	
	connect(fileList, SIGNAL(fileListChanged(int)), this, SLOT(slotFileListChanged(int)));

	readConfig();
	

}

KernelOptions::~KernelOptions() {
	
}

bool KernelOptions::isValid() {
	if (fileList->count()>0)
		return(true);
	else
		return(false);
}

void KernelOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void KernelOptions::saveConfig() {
	kdDebug() << "Saving config from Kernel Options..." << endl;
	
	QStringList stringList;
	QValueList<int> valueList;
		
	fileList->saveConfig(stringList, valueList);
	
	KSystemLogConfig::setKernelPaths(stringList);
	KSystemLogConfig::setKernelLevels(valueList);
}

void KernelOptions::readConfig() {
	QStringList stringList=KSystemLogConfig::kernelPaths();
	QValueList<int> valueList=KSystemLogConfig::kernelLevels();
	
	fileList->readConfig(stringList, valueList);
}


#include "kernelOptions.moc"
