/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/



#include <qlayout.h>
#include <qlabel.h>
#include <qvgroupbox.h>
#include <qbutton.h>
#include <qradiobutton.h>
#include <qwhatsthis.h>
#include <qtooltip.h>

#include <klocale.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "ksystemlogConfig.h"
#include "generalOptions.h"

GeneralOptions::GeneralOptions(QWidget *parent) : 
	QWidget(parent) 
	{

	QVBoxLayout *layout = new QVBoxLayout(this);
	layout->setSpacing(10);
	
	//Maximum Lines
	QVGroupBox* logLinesBox=new QVGroupBox(i18n("Log Lines List"), this);
	new QLabel(i18n("Maximum lines displayed:"), logLinesBox);
	maxLines=new QSpinBox(10, 30000, 10, logLinesBox);
	connect(maxLines, SIGNAL(valueChanged(int)), this, SLOT(onOptionsChanged()));
	
	QToolTip::add(maxLines, i18n("<qt>Choose here the maximum number of log lines displayed in the main view.</qt>"));
	QWhatsThis::add(maxLines, i18n("<qt>You can choose here the maximum number of log lines displayed in the main view.</qt>"));

	deleteDuplicatedLines=new QCheckBox(i18n("Delete duplicated log lines (may be slow)"), logLinesBox);
	connect(deleteDuplicatedLines, SIGNAL(clicked()), this, SLOT(onOptionsChanged()));
	
	QToolTip::add(deleteDuplicatedLines, i18n("<qt>Select this option if you want to delete duplicated log lines <b>(may be slow)</b>.</qt>"));
	QWhatsThis::add(deleteDuplicatedLines, i18n("<qt>You can select this option if you want to delete duplicated log lines. <b>This option can slow the reading</b>.</qt>"));


	
	//Maximum Characters per line
	QVGroupBox* maxCharBox=new QVGroupBox(i18n("Maximum Characters to Read per Line"), this);
	new QLabel(i18n("Number of characters:"), maxCharBox);
	maxCharacters=new QSpinBox(10, 30000, 10, maxCharBox);
	connect(maxCharacters, SIGNAL(valueChanged(int)), this, SLOT(onOptionsChanged()));

	QToolTip::add(maxCharacters, i18n("<qt>Choose here the maximum number of characters to read from each log line.</qt>"));
	QWhatsThis::add(maxCharacters, i18n("<qt>You can choose here the maximum number of characters to read from each log line.</qt>")); 
	

	QVGroupBox* options= new QVGroupBox( i18n( "Options" ), this );
	
	deleteProcessId=new QCheckBox(i18n("Delete process identifier from process name"), options);
	connect(deleteProcessId, SIGNAL(clicked()), this, SLOT(onOptionsChanged()));
	
	QToolTip::add(deleteProcessId, i18n("<qt>Delete process identifier from process name.</qt>"));
	QWhatsThis::add(deleteProcessId, i18n("<qt>You can select this option if you want to delete the process identifier from process name. For example, you will sometimes see in the <b>Process</b> column something like <i>cron<b>[3433]</b></i>. If this option is activated, the annoying bold part will be erased.</qt>"));

	colorizeLogLines=new QCheckBox(i18n("Colorize log lines"), options);
	connect(colorizeLogLines, SIGNAL(clicked()), this, SLOT(onOptionsChanged()));
	
	QToolTip::add(colorizeLogLines, i18n("<qt>This option allows the colorization of log lines, depending on their log level.</qt>"));
	QWhatsThis::add(colorizeLogLines, i18n("<qt>This option allows the colorization of log lines, depending on their log level. For example, an error will be in red, a warning in orange... This will help you to better see problems.</qt>"));
	
	QSpacerItem* spacer=new QSpacerItem(0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding);

	layout->addWidget(logLinesBox);
	layout->addWidget(maxCharBox);
	layout->addWidget(options);
	
	layout->addItem(spacer);
	
	readConfig();
}


void GeneralOptions::readConfig() {
	int value;
	
	value=KSystemLogConfig::maxLines();
	maxLines->setValue(value);

	value=KSystemLogConfig::maxReadCharacters();
	maxCharacters->setValue(value);
	
	bool option=KSystemLogConfig::deleteDuplicatedLines();
	deleteDuplicatedLines->setChecked(option);

	option=KSystemLogConfig::deleteProcessIdentifier();
	deleteProcessId->setChecked(option);

	option=KSystemLogConfig::colorizeLogLines();
	colorizeLogLines->setChecked(option);

}

void GeneralOptions::saveConfig() {
	kdDebug() << "Save config from General preferences" << endl;
	
	KSystemLogConfig::setMaxLines(maxLines->value());
	KSystemLogConfig::setMaxReadCharacters(maxCharacters->value());
	KSystemLogConfig::setDeleteDuplicatedLines(deleteDuplicatedLines->isChecked());
	KSystemLogConfig::setDeleteProcessIdentifier(deleteProcessId->isChecked());
	KSystemLogConfig::setColorizeLogLines(colorizeLogLines->isChecked());

}

bool GeneralOptions::isValid() {
	return(maxLines->value()>0 && maxCharacters->value()>0);
}


void GeneralOptions::onOptionsChanged() {
	emit optionsChanged(true);
}



#include "generalOptions.moc"
