/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//Qt includes
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

//KDE includes
#include <kstdguiitem.h>
#include <ktextedit.h>
#include <kguiitem.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kdebug.h>

//Project includes
#include "parentLogLine.h"

#include "detailDialog.h"

DetailDialog::DetailDialog(View* v, QWidget *parent, const char *name) :
	//KDialogBase(parent, name, false, i18n("Log Line Details"), 0 /*KDialogBase::Ok*/),
	DetailDialogBase(parent, name, false, 0),
	view(v),
	currentLine(NULL) {
	
	
	previous->setText(i18n("&Previous"));
	connect(previous, SIGNAL(clicked()), this, SLOT(previousItem()));
	
	next->setText(i18n("&Next"));
	connect(next, SIGNAL(clicked()), this, SLOT(nextItem()));
	
	//close->setText(KStdGuiItem::close().text());
	//close->setIcon(KStdGuiItem::close().iconSet());
	connect(closeButton, SIGNAL(clicked()), this, SLOT(closeDetails()));
	
	updateDetails();
	
	/* This code has been replaced by a pretty drawing of the Detail Dialog with Qt Designer
	
	setMinimumHeight(200);
	setMinimumWidth(450);
	
	QWhatsThis::add(this, i18n("This dialog displays detailed information about the currently selected log line."));
	
	QWidget* widget=new QWidget(this);
	
	QVBoxLayout* mainLayout = new QVBoxLayout(widget, 0, 10);

	QHBoxLayout* l1 = new QHBoxLayout(0, 0, 5);

	icon=new QLabel(widget);
	//icon->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum ) );
	l1->addWidget(icon, 0, Qt::AlignVCenter);

	//header=new KActiveLabel(widget, "header");
	header=new QLabel(widget, "header");
	//header->setSizePolicy( QSizePolicy( QSizePolicy::Maximum, QSizePolicy::Minimum) );
	//header->setSizePolicy( QSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::Minimum ) );
	l1->addWidget(header, 0, Qt::AlignVCenter || Qt::AlignHCenter);
	
	mainLayout->addLayout(l1);

	message=new QTextEdit(widget);
	message->setReadOnly(true);
	//message->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum) );
	//message->setSizePolicy( QSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding ) );
	//message->setMinimumHeight(40);
	//message->setMinimumHeight(60);
	//message->setMinimumWidth(400);
	
	mainLayout->addWidget(message);
	
	QHBoxLayout* buttons=new QHBoxLayout(0, 0, 10);
	
	
	previous=new QPushButton(KStdGuiItem::back().iconSet(), i18n("&Previous"), widget);
	connect(previous, SIGNAL(clicked()), this, SLOT(previousItem()));
	//1=Stretch factor (ratio between object in the QHBoxLayout)
	buttons->addWidget(previous, 1, Qt::AlignRight);
	
	QToolTip::add(previous, i18n("Move to the previous line"));
	QWhatsThis::add(previous, i18n("Moves to the previous line. This button is deactivated if there is no previous log line."));

	buttons->setStretchFactor(previous, 1);
	next=new QPushButton(KStdGuiItem::forward().iconSet(), i18n("&Next"), widget);
	connect(next, SIGNAL(clicked()), this, SLOT(nextItem()));
	//1=Stretch factor (ratio between object in the QHBoxLayout)
	buttons->addWidget(next, 1, Qt::AlignLeft);
	
	
	QToolTip::add(next, i18n("Move to the next line"));
	QWhatsThis::add(next, i18n("Moves to the next line. This button is deactivated if there is no next log line."));
	
	
	QPushButton* close=new QPushButton(KStdGuiItem::close().iconSet(), KStdGuiItem::close().text(), widget);
	connect(close, SIGNAL(clicked()), this, SLOT(closeDetails()));
	buttons->addWidget(close, 0, Qt::AlignRight);

	QToolTip::add(next, i18n("Close the Detail dialog."));
	QWhatsThis::add(next, i18n("Closes this Detail dialog."));
	
	mainLayout->addLayout(buttons);

	this->setMainWidget(widget);
	
	//TODO Try to find a better solution (if it exists!)
	//resize(500, 200);
	*/

}

DetailDialog::~DetailDialog() {

}

void DetailDialog::setView(View* view) {
	this->view=view;
	updateDetails();
}

void DetailDialog::selectionChanged() {
	updateDetails();
}

//TODO Try to find a method that reload (an resize) correctly the content of the detail dialog
void DetailDialog::updateDetails() {
	//Get the current-last item selected
	currentLine=view->getLastSelectedItem();
	if (currentLine==NULL) {
		//If no item are selected and the dialog is still open, we try to select the first
		//item of the list.
		currentLine=static_cast<LogListItem*> (view->getLogList()->firstChild());
		if (currentLine==NULL) {
			close();

			return;
		}
		
		
	}
	
	LogLine* logLine=currentLine->getLogLine();
	
	//Special case if this is a ParentLogLine (Group By feature)
	if (logLine->isParentLogLine()) {
		icon->setPixmap(DesktopIcon(GROUP_BY_ICON));
		header->setText(currentLine->getFormattedText());
		message->setText("");
	}
	//Normal Log Line
	else {
		icon->setPixmap(DesktopIcon(logLine->getLogLevel()->icon));
		
		header->setText(currentLine->getFormattedText());
		
		message->setText(logLine->getItemList().last());
	}
	
		
	if (currentLine->itemAbove()==NULL)
		previous->setEnabled(false);
	else
		previous->setEnabled(true);
	

	if (currentLine->itemBelow()==NULL)
		next->setEnabled(false);
	else
		next->setEnabled(true);
		
		
	header->adjustSize();
	this->adjustSize();
}

void DetailDialog::previousItem() {
	//This case should not occurs
	if (currentLine==NULL)
		return;
		
	//This case should not occurs
	if (currentLine->itemAbove()==NULL) {
		close();
		return;
	}
		
	currentLine->setSelected(false);
	currentLine->repaint();
	currentLine=static_cast<LogListItem*> (currentLine->itemAbove());
	currentLine->setSelected(true);
	currentLine->repaint();
	
	
	updateDetails();
}

void DetailDialog::closeDetails() {
	this->close();
}

void DetailDialog::nextItem() {
	//This case should not occurs
	if (currentLine==NULL)
		return;
	
	//This case should not occurs
	if (currentLine->itemBelow()==NULL) {
		close();
		return;
	}
		
	currentLine->setSelected(false);
	currentLine->repaint();
	currentLine=static_cast<LogListItem*> (currentLine->itemBelow());
	currentLine->setSelected(true);
	currentLine->repaint();
	
	updateDetails();

}

#include "detailDialog.moc"
