/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#ifndef _BOOT_AUTHENTICATION_OPTIONS_H_
#define _BOOT_AUTHENTICATION_OPTIONS_H_

#include <qframe.h>
#include <qspinbox.h>
#include <qbuttongroup.h>

#include <kconfig.h>
#include <kdialogbase.h>
 
#include <kurlrequester.h>

#include "globals.h"



class BootAuthenticationOptions : public QWidget {
	Q_OBJECT
	public:
		BootAuthenticationOptions(QWidget *parent = 0);
		
		bool isValid();

	public slots:
		void saveConfig();
		void readConfig();

	signals:
		void optionsChanged(bool valid);
	
	private slots:
		void onOptionsChanged(const QString&);
		
	private:
		KURLRequester* bootURLRequester;
		KURLRequester* authenticationURLRequester;

};

#endif // _BOOT_AUTHENTICATION_OPTIONS_H_
