/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _APACHE_OPTIONS_H_
#define _APACHE_OPTIONS_H_

#include <qframe.h>
#include <qspinbox.h>

#include <kpopupmenu.h>
#include <kconfig.h>
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <kurl.h>
#include <kaction.h>
#include <ktabwidget.h>

#include "globals.h"
#include "fileList.h"
#include "logMode.h"


class ApacheOptions : public QWidget {
	
	Q_OBJECT
	
	public:
		ApacheOptions(QWidget *parent = 0);
		~ApacheOptions();
		
		bool isValid();

	public slots:
		void saveConfig();
		void readConfig();

		void slotFileListChanged(int itemLeft);

	signals:
		void optionsChanged(bool valid);

	private:

		KTabWidget tabs;
		
		FileList apacheFileList;
		
		FileList apacheAccessFileList;
};

#endif
