/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>

//KDE includes
#include <klocale.h>
#include <kactioncollection.h>
#include <kbuttonbox.h>
#include <klistbox.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

//Project includes
#include "apacheOptions.h"
#include "ksystemlogConfig.h"

ApacheOptions::ApacheOptions(QWidget *parent) :
	QWidget(parent),
	tabs(this, "tabs"),
	apacheFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Apache log</b>. This list also determines the order in which the files are read.</p></qt>")),
	apacheAccessFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Apache Access log</b>. This list also determines the order in which the files are read.</p></qt>"))
	{
	
	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->setAutoAdd(true);

	tabs.addTab(&apacheFileList, Globals::apacheMode->pixmap, Globals::apacheMode->name);
	tabs.addTab(&apacheAccessFileList, Globals::apacheAccessMode->pixmap, Globals::apacheAccessMode->name);
	
	connect(&apacheFileList, SIGNAL(fileListChanged(int)), this, SLOT(slotFileListChanged(int)));
	connect(&apacheAccessFileList, SIGNAL(fileListChanged(int)), this, SLOT(slotFileListChanged(int)));
	
	readConfig();
	

}

ApacheOptions::~ApacheOptions() {

}

bool ApacheOptions::isValid() {
	if (apacheFileList.count()>0 && apacheAccessFileList.count()>0)
		return(true);
	else
		return(false);
}

void ApacheOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void ApacheOptions::saveConfig() {
	kdDebug() << "Save config from ApacheOptions" << endl;
	
	QStringList list;
	
	int count=apacheFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(apacheFileList.getText(i));
	}
	
	KSystemLogConfig::setApachePaths(list);

	list.clear();
	
	count=apacheAccessFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(apacheAccessFileList.getText(i));
	}
	
	KSystemLogConfig::setApacheAccessPaths(list);

}

void ApacheOptions::readConfig() {
	QStringList apacheFiles(KSystemLogConfig::apachePaths());
		
	QStringList::iterator it;
	for(it=apacheFiles.begin(); it!=apacheFiles.end(); ++it) {
		apacheFileList.insertItem(*it);
	}

	QStringList apacheAccessFiles(KSystemLogConfig::apacheAccessPaths());
		
	for(it=apacheAccessFiles.begin(); it!=apacheAccessFiles.end(); ++it) {
		apacheAccessFileList.insertItem(*it);
	}
}

#include "apacheOptions.moc"
