/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kmessagebox.h>

#include "parsingHelper.h"

#include "acpidReader.h"

AcpidReader::AcpidReader(QObject *parent, const char *name) : 
	DefaultReader(parent, name)
	{
}


AcpidReader::~AcpidReader() {

}


void AcpidReader::initColumns(LogViewColumns* columns) {
	columns->append(new LogViewColumn(i18n("Date"), true, false));
	columns->append(new LogViewColumn(i18n("Type"), true, true));
	columns->append(new LogViewColumn(i18n("Message"), true, false));

}

LogLine* AcpidReader::parseMessage(QString& logLine, LogFile* logFile) {

	int dateBegin=logLine.find("[");
	int dateEnd=logLine.find("]");
	
	QString type;
	QString message;
	QDate date;
	QTime time;
	
	//If there is a format problem in the line
	if (dateBegin==-1 || dateEnd==-1) {
		type=i18n("none");
		message=logLine;
		date=QDate::currentDate();
		time=QTime::currentTime();
	}
	else {
	
		QString strDate=logLine.mid(dateBegin+1, dateEnd-dateBegin-1);
		
		QString month=strDate.mid(4, 3);
		
		QString day=strDate.mid(8, 2);
		
		QString hour=strDate.mid(11, 2);
		QString min=strDate.mid(14, 2);
		QString sec=strDate.mid(17, 2);
		
		QString year=strDate.mid(20, 4);
	
		date=QDate(year.toInt(), ParsingHelper::parseMonthNumber(month), day.toInt());
		time=QTime(hour.toInt(), min.toInt(), sec.toInt());
		
		//kdDebug() << "Date=" << date.toString() << endl;
		//kdDebug() << "Time=" << time.toString() << endl;
		
		logLine=logLine.remove(0, dateEnd+2);
		
		int endType=logLine.find("\"");
		
		//If the " character does not exist, it means that there is no Type category
		if (endType==-1) {
			type=i18n("none");
			message=logLine;
		}
		else {
			type=logLine.left(endType-1);
			logLine=logLine.remove(0, endType+1);
	
			message=logLine.left(logLine.length()-2);
		}
		
	}
	
	
	QStringList list;
	
	list.push_back(type);
	list.push_back(message);

	QString filePath=logFile->url.path();
	LogLine* line=new LogLine(date, time, list, filePath, Globals::informationLogLevel, Globals::acpidMode->id);
	return(line);
}


#include "acpidReader.moc"
