// (c) 2004 Mark Kretschmann <markey@web.de>
// (c) 2004 Pierpaolo Di Panfilo <pippo_dp@libero.it>
// (c) 2005 Alexandre Pereira de Oliveira <aleprj@gmail.com>
// See COPYING file for licensing information.

#ifndef AMAROK_TAGDIALOG_H
#define AMAROK_TAGDIALOG_H

#include "config.h"

#include "htmlview.h"
#include "ktrm.h"
#include "metabundle.h"       //stack alloc
#include "tagdialogbase.h"    //baseclass
#include "tqwidget.h"

#include <kurl.h>             //stack alloc
#include <tqdatetime.h>
#include <tqlabel.h>
#include <tqmap.h>
#include <tqptrlist.h>

#include <khtml_part.h>


class PlaylistItem;
namespace TagLib {
    namespace ID3v2 {
        class Tag;
    }
}

class TagDialog : public TagDialogBase
{
    Q_OBJECT

    public:

        enum Changes { NOCHANGE=0, SCORECHANGED=1, TAGSCHANGED=2, LYRICSCHANGED=4, RATINGCHANGED=8, LABELSCHANGED=16 };
        enum Tabs { SUMMARYTAB, TAGSTAB, LYRICSTAB, STATSTAB, LABELSTAB };

        TagDialog( const KURL& url, TQWidget* parent = 0 );
        TagDialog( const KURL::List list, TQWidget* parent = 0 );
        TagDialog( const MetaBundle& mb, PlaylistItem* item, TQWidget* parent = 0 );
        ~TagDialog();

        void setTab( int id );

        friend class TagSelect;

    signals:
        void lyricsChanged( const TQString& );

    public slots:
        void openURLRequest(const KURL &url );

    private slots:
        void accept();
        void cancelPressed();
        void openPressed();
        void previousTrack();
        void nextTrack();
        void perTrack();
        void checkModified();

        void loadCover( const TQString &artist, const TQString &album );

        void musicbrainzQuery();
        void guessFromFilename();
        void setFileNameSchemes();
        void queryDone( KTRMResultList results, TQString error );
        void fillSelected( KTRMResult selected );
        void resetMusicbrainz();

    private:
        void init();
        void readTags();
        void readMultipleTracks();
        void setMultipleTracksMode();
        void setSingleTrackMode();
        void enableItems();
        bool hasChanged();
        int changes();
        void storeTags();
        void storeTags( const KURL& url );
        void storeTags( const KURL& url, int changes, const MetaBundle &mb );
        void storeLabels( const KURL &url, const TQStringList &labels );
        void loadTags( const KURL& url );
        void loadLyrics( const KURL& url );
        void loadLabels( const KURL &url );
        MetaBundle bundleForURL( const KURL &url );
        float scoreForURL( const KURL &url );
        int ratingForURL( const KURL &url );
        TQString lyricsForURL( const KURL &url );
        TQStringList labelsForURL( const KURL &url );
        TQStringList getCommonLabels();
        void saveTags();
        bool writeTag( MetaBundle &mb, bool updateCB=true );
        const TQString unknownSafe( TQString );
        const TQStringList statisticsData();
        void applyToAllTracks();

        const TQStringList filenameSchemes();

        TQStringList labelListFromText( const TQString &text );
        void generateDeltaForLabelList( const TQStringList &list );
        TQString generateHTML( const TQStringList &labels );

        MetaBundle m_bundle;
        KURL::List::iterator m_currentURL;
        TQString m_lyrics;
        bool m_perTrack;
        PlaylistItem* m_playlistItem;
        TQMap<TQString, MetaBundle> storedTags;
        TQMap<TQString, float> storedScores;
        TQMap<TQString, int> storedRatings;
        TQMap<TQString, TQString> storedLyrics;
        TQMap<TQString, TQStringList> newLabels;
        TQMap<TQString, TQStringList> originalLabels;
        KURL::List m_urlList;
        TQString m_buttonMbText;
        TQString m_path;
        TQString m_currentCover;
        TQStringList m_labels;
        TQStringList m_addedLabels;
        TQStringList m_removedLabels;
        KURL m_mbTrack;
        TQString m_commaSeparatedLabels;
        //KHTMLPart *m_labelCloud;
        HTMLView *m_labelCloud;
};


#endif /*AMAROK_TAGDIALOG_H*/

