/***************************************************************************
  begin                : Fre Nov 15 2002
  copyright            : (C) Mark Kretschmann <markey@web.de>
                       : (C) Max Howell <max.howell@methylblue.com>
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAROK_PLAYLISTWINDOW_H
#define AMAROK_PLAYLISTWINDOW_H

#include "browserbar.h"

#include <tqhbox.h>          //baseclass for DynamicBox
#include <tqwidget.h>        //baseclass
#include <kxmlguiclient.h>  //baseclass (for XMLGUI)

class ClickLineEdit;
class CollectionBrowser;
class ContextBrowser;
class MediaBrowser;
class TQMenuBar;
class KPopupMenu;
class KToolBar;
class TQLabel;
class TQTimer;

/**
  * @class PlaylistWindow
  * @short The PlaylistWindow widget class.
  *
  * This is the main window widget (the Playlist not Player).
  */
class PlaylistWindow : public TQWidget, public KXMLGUIClient
{
        Q_OBJECT

    public:
        PlaylistWindow();
       ~PlaylistWindow();

        void init();
        void applySettings();

        void createGUI(); //should be private but App::slowConfigToolbars requires it
        void recreateGUI();

        //allows us to switch browsers from within other browsers etc
        void showBrowser( const TQString& name ) { m_browsers->showBrowser( name ); }
        void addBrowser( const TQString &name, TQWidget *widget, const TQString &text, const TQString &icon );

        //takes into account minimized, multiple desktops, etc.
        bool isReallyShown() const;

        virtual bool eventFilter( TQObject*, TQEvent* );

        //instance is declared in KXMLGUI
        static PlaylistWindow *self() { return s_instance; }

        void activate();

    public slots:
        void showHide();
        void mbAvailabilityChanged( bool isAvailable );

    private slots:
        void savePlaylist() const;
        void slotBurnPlaylist() const;
        void slotPlayMedia();
        void slotAddLocation( bool directPlay = false );
        void slotAddStream();
        void playLastfmPersonal();
        void addLastfmPersonal();
        void playLastfmNeighbor();
        void addLastfmNeighbor();
        void playLastfmCustom();
        void addLastfmCustom();
        void playLastfmGlobaltag( int );
        void addLastfmGlobaltag( int );
        void playAudioCD();
        void showQueueManager();
        void showScriptSelector();
        void showStatistics();
        void slotMenuActivated( int );
        void actionsMenuAboutToShow();
        void toolsMenuAboutToShow();
        void slotToggleMenu();
        void slotToggleFocus();
        void slotEditFilter();
        void slotSetFilter( const TQString &filter );

    protected:
        virtual void closeEvent( TQCloseEvent* );
        virtual void showEvent( TQShowEvent* );
        virtual TQSize sizeHint() const;

    private:
        enum MenuId { ID_SHOW_TOOLBAR = 2000, ID_SHOW_PLAYERWINDOW };

        TQMenuBar      *m_menubar;
        KPopupMenu    *m_toolsMenu;
        KPopupMenu    *m_settingsMenu;
        BrowserBar    *m_browsers;
        KPopupMenu    *m_searchMenu;
        ClickLineEdit *m_lineEdit;
        KToolBar      *m_toolbar;
        TQTimer        *m_timer;  //search filter timer
        TQStringList    m_lastfmTags;
        MediaBrowser  *m_currMediaBrowser;

        int m_lastBrowser;
        int m_searchField;

        static PlaylistWindow *s_instance;
};

class DynamicTitle : public QWidget
{
    Q_OBJECT
    public:
        DynamicTitle( TQWidget* parent );
        void setTitle( const TQString& newTitle );

    protected:
        virtual void paintEvent( TQPaintEvent* e );

    private:
        static const int s_curveWidth = 5;
        static const int s_imageSize = 16;
        TQString m_title;
        TQFont m_font;
};

class DynamicBar : public QHBox
{
    Q_OBJECT
    public:
        DynamicBar( TQWidget* parent );
        void init();

    public slots:
        void slotNewDynamicMode( const DynamicMode* mode );
        void changeTitle( const TQString& title );

    private:
        DynamicTitle* m_titleWidget;
};


#endif //AMAROK_PLAYLISTWINDOW_H
