/****************************************************************************
 * copyright            :(C) 2006 Roel Meeuws <r.j.meeuws+amarok@gmail.com> *
 *                       (C) 2005 Jeff Mitchell <kde-dev@emailgoeshere.com> *
 *                       (C) 2005 Seb Ruiz <me@sebruiz.net>                 *
 *                                                                          *
 * With some code helpers from KIO_GENERIC                                  *
 *                        (c) 2004 Thomas Loeber <vfat@loeber1.de>          *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef AMAROK_GENERICMEDIADEVICE_H
#define AMAROK_GENERICMEDIADEVICE_H

#include "mediabrowser.h"
#include "transferdialog.h"

#include <kdirlister.h>
#include <kurl.h>

#include <tqptrlist.h>

class GenericMediaItem;
class GenericMediaFile;
class GenericMediaDeviceConfigDialog;
class PodcastEpisodeBundle;

class TQStringList;

typedef TQMap<TQString, GenericMediaFile*> MediaFileMap;
typedef TQMap<GenericMediaItem*, GenericMediaFile*> MediaItemMap;

class GenericMediaDevice : public MediaDevice
{
    Q_OBJECT

    friend  class GenericMediaDeviceConfigDialog;

    public:
                          GenericMediaDevice();
        void              init( MediaBrowser* parent );
        virtual           ~GenericMediaDevice();

        bool              isConnected() { return m_connected; }

        void              rmbPressed( TQListViewItem* qitem, const TQPoint& point, int );

        TQStringList       supportedFiletypes() { return m_supportedFileTypes; }
        bool              isPlayable( const MetaBundle& bundle );
        bool              isPreferredFormat( const MetaBundle &bundle );

        bool              needsManualConfig() { return false; }
        void              addConfigElements( TQWidget * parent );
        void              removeConfigElements( TQWidget * /* parent */);

        void              applyConfig();
        void              loadConfig();

        MediaFileMap     &getFileMap() { return m_mfm; }
        MediaItemMap     &getItemMap() { return m_mim; }
        GenericMediaFile *getInitialFile() { return m_initialFile; }

    protected:
        bool              openDevice( bool silent=false );
        bool              closeDevice();

        MediaItem        *copyTrackToDevice( const MetaBundle& bundle );
        int               deleteItemFromDevice( MediaItem *item, int flags=DeleteTrack );
        MediaItem        *newDirectory( const TQString &name, MediaItem *parent );
        void              addToDirectory( MediaItem *directory, TQPtrList<MediaItem> items );

        bool              getCapacity( KIO::filesize_t *total, KIO::filesize_t *available );
        TQString           fileName( const MetaBundle & );

        //methods not implemented/needed
        bool              lockDevice( bool ) { return true; }
        void              unlockDevice() {}
        void              synchronizeDevice() {}
        void              addToPlaylist( MediaItem *, MediaItem *, TQPtrList<MediaItem> ) {}
        MediaItem        *newPlaylist( const TQString &, MediaItem *, TQPtrList<MediaItem> ) { return 0; }


    signals:
        void              startTransfer();


    protected slots:
        void              renameItem( TQListViewItem *item );
        void              expandItem( TQListViewItem *item );
        void              foundMountPoint( const TQString & mountPoint, unsigned long kBSize, unsigned long kBUsed, unsigned long kBAvail );
        void              refreshDir( const TQString &dir );

        void              newItems( const KFileItemList &items );
        void              dirListerCompleted();
        void              dirListerClear();
        void              dirListerClear( const KURL &url );
        void              dirListerDeleteItem( KFileItem *fileitem );


    private:
        enum              Error { ERR_ACCESS_DENIED, ERR_CANNOT_RENAME, ERR_DISK_FULL, ERR_COULD_NOT_WRITE };

        MediaItem        *trackExists( const MetaBundle& );

        TQString           buildDestination( const TQString &format, const MetaBundle &mb );
        TQString           buildPodcastDestination( const PodcastEpisodeBundle *bundle );
        void              checkAndBuildLocation( const TQString& location );

        KURL::List        getSelectedItems();
        void              downloadSelectedItems();
        void              copyTrackSortHelper( const MetaBundle& bundle, TQString& sort, TQString& base );

        void              listDir( const TQString &dir );
        int               addTrackToList( int type, KURL name, int size=0 );

        TQString           cleanPath( const TQString &component );

        GenericMediaFile     *m_initialFile;

        KIO::filesize_t   m_kBSize;
        KIO::filesize_t   m_kBAvail;

        KDirLister        *m_dirLister;

        bool              m_actuallyVfat;
        bool              m_dirListerComplete;
        bool              m_connected;
        KURL::List        m_downloadList;
        MediaFileMap      m_mfm;
        MediaItemMap      m_mim;

        TQStringList       m_supportedFileTypes;
        TQString           m_songLocation;
        TQString           m_podcastLocation;
        bool              m_asciiTextOnly;
        bool              m_vfatTextOnly;
        bool              m_ignoreThePrefix;

        GenericMediaDeviceConfigDialog *m_configDialog;
};

#endif /*AMAROK_GENERICMEDIADEVICE_H*/
