/***************************************************************************
 * copyright            : (C) 2006 Ian Monroe <ian@monroe.nu>              *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DAAPCONTENTFETCHER_H
#define DAAPCONTENTFETCHER_H

#include <tqhttp.h>

class TQDataStream;
class TQFile;

namespace Daap {

/**
   Inspired by a daapsharp class of the same name. Basically it adds all the silly headers
   that DAAP needs
	@author Ian Monroe <ian@monroe.nu>
*/
class ContentFetcher : public QHttp
{
    Q_OBJECT

    public:
        ContentFetcher( const TQString & hostname, Q_UINT16 port, const TQString& password, TQObject * parent = 0, const char * name = 0 );
        ~ContentFetcher();

        void getDaap( const TQString & command, TQIODevice* musicFile = 0 );
        TQDataStream& results();

    private slots:
        void checkForErrors( int state );

    signals:
        void httpError( const TQString& );

    private:
        TQString m_hostname;
        Q_UINT16 m_port;
        TQCString m_authorize;
        bool m_selfDestruct;
        static int s_requestId; //! Apple needs this for some reason
};



}

#endif
