/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include "amarok.h"
#include "config.h"
#include "directorylist.h"

#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <tqpushbutton.h>

namespace Amarok
{
    extern TQPixmap getPNG( const TQString& );
    extern TQPixmap getJPG( const TQString& );

    extern KConfig *config( const TQString& );
}

void
FirstRunWizard::init()
{
    using namespace Amarok;

    //aesthetics
    helpButton()->hide();

    picture1->setPixmap( getJPG( "amarok_rocks" ) );
    picture4->setPixmap( *picture1->pixmap() );

    WizardPageLayout_2->addWidget( m_folderSetup = new CollectionSetup( WizardPage_2 ) );

    text4->disconnect( TQT_SIGNAL(linkClicked( const TQString& )) );
    connect( text4, TQT_SIGNAL(linkClicked( const TQString& )), TQT_SLOT(invokeHandbook()) );
    dbActiveLabel->disconnect( TQT_SIGNAL(linkClicked( const TQString& )) );
    connect( dbActiveLabel, TQT_SIGNAL(linkClicked( const TQString& )), TQT_SLOT(openLink( const TQString &)) );
    setFinishEnabled ( WizardPage_4, true );
#if !defined(USE_MYSQL) && !defined(USE_POSTGRESQL)
        removePage(WizardPage_3);
#endif

}

void
FirstRunWizard::showPage( TQWidget *w ) //virtual
{
    TQWizard::showPage( w );

    cancelButton()->setText( w == WizardPage ? i18n("&Skip") : i18n("&Cancel") );
}

inline void
FirstRunWizard::invokeHandbook() //SLOT
{
    // Show handbook
    kapp->invokeHelp( TQString::null, TQString::null, 0 );
}

void
FirstRunWizard::writeCollectionConfig()
{
    m_folderSetup->writeConfig();
}

void
FirstRunWizard::openLink(const TQString& s)
{
    Amarok::invokeBrowser(s);
}
