// (c) 2006 Giovanni Venturi <giovanni@kde-it.org>
// See COPYING file for licensing information.

#ifndef AMAROK_EDITFILTERDIALOG_H
#define AMAROK_EDITFILTERDIALOG_H

#include <tqvaluelist.h>
#include <tqvaluevector.h>

#include <kdialogbase.h>

class TQWidget;
class TQVBoxLayout;
class TQComboBox;
class TQCheckBox;
class TQLineEdit;
class TQRadioButton;
class TQGroupBox;
class TQSpinBox;
class TQStringList;
class KComboBox;

class EditFilterDialog : public KDialogBase
{
    Q_OBJECT
    public:
        EditFilterDialog( TQWidget* parent, bool metaBundleKeywords, const TQString &text = "" );
        ~EditFilterDialog();

        TQString filter() const;

    signals:
        void filterChanged( const TQString &filter );

    private:
        TQVBoxLayout *m_mainLay;

        TQCheckBox *m_prefixNOT;
        TQComboBox *m_comboKeyword;
        KLineEdit *m_editKeyword;

        TQGroupBox *m_groupBox;

        TQComboBox *m_comboCondition;
        TQLabel *m_filesizeLabel;
        TQComboBox *m_comboUnitSize;

        TQRadioButton *m_minMaxRadio;
        TQSpinBox *m_spinMin1, *m_spinMin2;
        TQLabel *m_andLabel;
        TQSpinBox *m_spinMax1, *m_spinMax2;

        TQGroupBox *m_groupBox2;
        TQRadioButton *m_checkALL;
        TQRadioButton *m_checkAtLeastOne;
        TQRadioButton *m_checkExactly;
        TQRadioButton *m_checkExclude;
        TQValueList<TQRadioButton*> m_actionCheck;

        TQGroupBox *m_groupBox3;
        TQRadioButton *m_checkAND;
        TQRadioButton *m_checkOR;

        bool m_appended;               // true if a filter appended
        int m_selectedIndex;           // the position of the selected keyword in the combobox
        TQValueVector<TQString> m_vector; // the vector of the amarok filter keyword
        TQString m_filterText;          // the resulting filter string
        TQString m_previousFilterText;  // the previous resulting filter string
        TQString m_strPrefixNOT;        // is empty if no NOT prefix is needed else it's "-"

    private:
        void exclusiveSelectOf( int which );
        TQString keywordConditionString(const TQString& keyword) const;
        void setMinMaxValueSpins();

    private slots:
        void selectedKeyword(int index);

        void minSpinChanged(int value);
        void maxSpinChanged(int value);

        void textWanted();
        void textWanted( const TQStringList &completions );
        void valueWanted();

        void chooseCondition(int index);
        void chooseOneValue();
        void chooseMinMaxValue();

        void slotCheckAll();
        void slotCheckAtLeastOne();
        void slotCheckExactly();
        void slotCheckExclude();

        void slotCheckAND();
        void slotCheckOR();

        void assignPrefixNOT();

    protected slots:
        virtual void slotDefault();
        virtual void slotUser1();
        virtual void slotUser2();
        virtual void slotOk();
};

#endif /* AMAROK_EDITFILTERDIALOG_H */
