// (c) 2004 Mark Kretschmann <markey@web.de>
// (c) 2004 Stefan Bogner <bochi@online.ms>
// See COPYING file for licensing information.

#ifndef AMAROK_COVERFETCHER_H
#define AMAROK_COVERFETCHER_H

#include <tqlabel.h>       //baseclass
#include <tqimage.h>       //stack allocated
#include <tqobject.h>      //baseclass
#include <tqstringlist.h>  //stack allocated
#include <tqdom.h>     //stack allocated

namespace Amarok {
    void coverContextMenu(  TQWidget *parent, TQPoint point, const TQString &artist, const TQString &album, bool showCoverManager = true );
}


class CoverLabel : public TQLabel {
    public:
    CoverLabel ( TQWidget * parent, const char * name = 0, WFlags f = 0 );

    void setInformation( const TQString artist, const TQString album ) {
        m_artist = artist;
        m_album = album;
    }

    protected:
    virtual void mouseReleaseEvent(TQMouseEvent *pEvent);

    private:
    TQString m_artist;
    TQString m_album;
};



namespace KIO { class Job; }

class CoverFetcher : public QObject
{
    friend class EditSearchDialog;
    Q_OBJECT

    static const uint MAX_COVERS_CHOICE = 10;

public:
    CoverFetcher( TQWidget *parent, const TQString &artist, TQString album );
   ~CoverFetcher();

    /// allow the user to edit the query?
    void setUserCanEditQuery( bool b ) { m_userCanEditQuery = b; }

    /// starts the fetch
    void startFetch();

    TQString artist() const { return m_artist; }
    TQString album() const { return m_album; }
    TQString amazonURL() const { return m_amazonURL; }
    TQString asin() const { return m_asin; }
    TQImage image() const { return m_image; }

    bool wasError() const { return !m_success; }
    TQStringList errors() const { return m_errors; }

    enum Locale { International=0, France, Germany, Japan, UK, Canada };
    static TQString localeIDToString( int id );
    static int localeStringToID( const TQString &locale );

signals:
    /// The CollectionDB can get the cover information using the pointer
    void result( CoverFetcher* );

private slots:
    void finishedXmlFetch( KIO::Job* job );
    void finishedImageFetch( KIO::Job* job );
    void changeLocale( int id );

private:
    const TQString m_artist;
    const TQString m_album;

    bool    m_userCanEditQuery;
    TQString m_userQuery; /// the query from the query edit dialog
    TQString m_xml;
    TQImage  m_image;
    TQString m_amazonURL;
    TQString m_asin;
    int     m_size;

    TQStringList m_queries;
    TQStringList m_coverAsins;
    TQStringList m_coverAmazonUrls;
    TQStringList m_coverUrls;
    TQStringList m_coverNames;
    TQString     m_currentCoverName;
    TQStringList m_errors;

    bool m_success;

private:
    /// The fetch was successful!
    void finish();

    /// Parse one <Item> TQDomNode and append results.
    void parseItemNode( const TQDomNode &node );

    /// The fetch failed, finish up and log an error message
    void finishWithError( const TQString &message, KIO::Job *job = 0 );

    /// Prompt the user for a query
    void getUserQuery( TQString explanation = TQString::null );

    /// Will try all available queries, and then prompt the user, if allowed
    void attemptAnotherFetch();

    /// Show the cover that has been found
    void showCover();
};

#endif /* AMAROK_COVERFETCHER_H */
