/***************************************************************************
                          amarokdcophandler.h  -  DCOP Implementation
                             -------------------
    begin                : Sat Oct 11 2003
    copyright            : (C) 2003 by Stanislav Karchebny
                           (C) 2005 Ian Monroe
                           (C) 2005 Seb Ruiz
    email                : berkus@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAROK_DCOP_HANDLER_H
#define AMAROK_DCOP_HANDLER_H

#include <tqobject.h>
#include "amarokdcopiface.h"
class AmarokConfig;

namespace Amarok
{

class DcopPlayerHandler : public TQObject, virtual public AmarokPlayerInterface
{
      Q_OBJECT

   public:
      DcopPlayerHandler();

   public:
      virtual TQString version();
      virtual bool dynamicModeStatus();
      virtual bool equalizerEnabled();
      virtual bool osdEnabled();
      virtual bool isPlaying();
      virtual bool randomModeStatus();
      virtual bool repeatPlaylistStatus();
      virtual bool repeatTrackStatus();
      virtual int  getVolume();
      virtual int sampleRate();
      virtual float score ();
      virtual int rating ();
      virtual int  status();
      virtual int  trackCurrentTime();
      virtual int  trackCurrentTimeMs();
      virtual int  trackPlayCounter();
      virtual int  trackTotalTime();
      virtual TQStringList labels();
      virtual TQString album();
      virtual TQString artist();
      virtual TQString bitrate();
      virtual TQString comment();
      virtual TQString coverImage();
      virtual TQString currentTime();
      virtual TQString encodedURL();
      virtual TQString engine();
      virtual TQString genre();
      virtual TQString lyrics();
      virtual TQString lyricsByPath( TQString path );
      virtual TQString lastfmStation();
      virtual TQString nowPlaying();
      virtual TQString path();
      virtual TQString setContextStyle(const TQString&);
      virtual TQString title();
      virtual TQString totalTime();
      virtual TQString track();
      virtual TQString type();
      virtual TQString year();
      virtual void configEqualizer();
      virtual void enableOSD( bool enable );
      virtual void enableRandomMode( bool enable );
      virtual void enableRepeatPlaylist( bool enable );
      virtual void enableRepeatTrack( bool enable );
      virtual void mediaDeviceMount();
      virtual void mediaDeviceUmount();
      virtual void mute();
      virtual void next();
      virtual void pause();
      virtual void play();
      virtual void playPause();
      virtual void prev();
      virtual void queueForTransfer( KURL url );
      virtual void seek( int s );
      virtual void seekRelative( int s );
      virtual void setEqualizer(int preamp, int band60, int band170, int band310, int band600, int band1k, int band3k, int band6k, int band12k, int band14k, int band16k);
      virtual void setEqualizerEnabled( bool active );
      virtual void setEqualizerPreset( TQString name );
      virtual void setLyricsByPath( const TQString& url, const TQString& lyrics );
      virtual void setScore( float score );
      virtual void setScoreByPath( const TQString &url, float score );
      virtual void setBpm( float bpm );
      virtual void setBpmByPath( const TQString &url, float bpm );
      virtual void setRating( int rating );
      virtual void setRatingByPath( const TQString &url, int rating );
      virtual void setVolume( int );
      virtual void setVolumeRelative( int );
      virtual void showBrowser( TQString browser );
      virtual void showOSD();
      virtual void stop();
      virtual void volumeDown();
      virtual void volumeUp();
      virtual void transferDeviceFiles();

    private:
      virtual void transferCliArgs( TQStringList args );
};


class DcopPlaylistHandler : public TQObject, virtual public AmarokPlaylistInterface
{
        Q_OBJECT

   public:
      DcopPlaylistHandler();

   public:
      virtual int     getActiveIndex();
      virtual int     getTotalTrackCount();
      virtual TQString saveCurrentPlaylist();
      virtual void    addMedia(const KURL &);
      virtual void    queueMedia(const KURL &);
      virtual void    addMediaList(const KURL::List &);
      virtual void    clearPlaylist();
      virtual TQString currentTrackUniqueId();
      virtual void    playByIndex(int);
      virtual void    playMedia(const KURL &);
      virtual void    popupMessage(const TQString&);
      virtual void    removeCurrentTrack();
      virtual void    removeByIndex(int);
      virtual void    repopulate();
      virtual void    saveM3u(const TQString& path, bool relativePaths);
      virtual void    setStopAfterCurrent(bool);
      virtual void    shortStatusMessage(const TQString&);
      virtual void    shufflePlaylist();
      virtual void    togglePlaylist();
      virtual TQStringList filenames();
};

class DcopPlaylistBrowserHandler : public TQObject, virtual public AmarokPlaylistBrowserInterface
{
        Q_OBJECT

   public:
      DcopPlaylistBrowserHandler();

   public:
      virtual void addPodcast( const TQString &url );
      virtual void scanPodcasts();
      virtual void addPlaylist( const TQString &url );
      virtual int loadPlaylist( const TQString &playlist );
};

class DcopContextBrowserHandler : public TQObject, virtual public AmarokContextBrowserInterface
{
        Q_OBJECT

   public:
      DcopContextBrowserHandler();

   public:
      virtual void showCurrentTrack();
      virtual void showLyrics();
      virtual void showWiki();
      virtual void showLyrics( const TQCString& lyrics );
};


class DcopCollectionHandler : public TQObject, virtual public AmarokCollectionInterface
{
   Q_OBJECT

   public:
       DcopCollectionHandler();

   public /* DCOP */ slots:
      virtual int totalAlbums();
      virtual int totalArtists();
      virtual int totalComposers();
      virtual int totalCompilations();
      virtual int totalGenres();
      virtual int totalTracks();
      virtual bool isDirInCollection( const TQString &path );
      virtual bool moveFile( const TQString &oldURL, const TQString &newURL, bool overwrite );
      virtual TQStringList query(const TQString& sql);
      virtual TQStringList similarArtists( int artists );
      virtual void migrateFile( const TQString &oldURL, const TQString &newURL );
      virtual void scanCollection();
      virtual void scanCollectionChanges();
      virtual void disableAutoScoring( bool disable );
      virtual void scanUnpause();
      virtual void scanPause();
      virtual void scannerAcknowledged();
      virtual int addLabels( const TQString &url, const TQStringList &labels );
      virtual void removeLabels( const TQString &url, const TQStringList &oldLabels );
      virtual int deviceId( const TQString &url );
      virtual TQString relativePath( const TQString &url );
      virtual TQString absolutePath( int deviceid, const TQString &relativePath );
};


class DcopScriptHandler : public TQObject, virtual public AmarokScriptInterface
{
   Q_OBJECT

   public:
       DcopScriptHandler();

   public /* DCOP */ slots:
      virtual bool runScript(const TQString&);
      virtual bool stopScript(const TQString&);
      virtual TQStringList listRunningScripts();
      virtual void addCustomMenuItem(TQString submenu, TQString itemTitle );
      virtual void removeCustomMenuItem(TQString submenu, TQString itemTitle );
      virtual TQString readConfig(const TQString& key);
      virtual TQStringList readListConfig(const TQString& key);
      virtual TQString proxyForUrl(const TQString& url);
      virtual TQString proxyForProtocol(const TQString& protocol);
};

class DcopDevicesHandler : public TQObject, virtual public AmarokDevicesInterface
{
   Q_OBJECT

   public:
       DcopDevicesHandler();

   public /* DCOP */ slots:
      virtual void mediumAdded(TQString name);
      virtual void mediumRemoved(TQString name);
      virtual void mediumChanged(TQString name);
      virtual TQStringList showDeviceList();
};

class DcopMediaBrowserHandler : public TQObject, virtual public AmarokMediaBrowserInterface
{
    Q_OBJECT

    public:
        DcopMediaBrowserHandler();

    public /* DCOP */ slots:
      virtual void deviceConnect();
      virtual void deviceDisconnect();
      virtual TQStringList deviceList();
      virtual void deviceSwitch( TQString name );
      virtual void queue( KURL url );
      virtual void queueList( KURL::List urls );
      virtual void transfer();
      virtual void transcodingFinished( TQString src, TQString dest );
};

} // namespace Amarok

#endif
