
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_ROSEGARDENQUANTIZEPARAMETERS_H_
#define _RG_ROSEGARDENQUANTIZEPARAMETERS_H_

#include <tqframe.h>
#include <tqstring.h>
#include <vector>
#include "base/Event.h"
#include <tqgroupbox.h>


class TQWidget;
class TQPushButton;
class TQLabel;
class TQGridLayout;
class TQCheckBox;
class KComboBox;


namespace Rosegarden
{

class Quantizer;


class QuantizeParameters : public QFrame
{
    Q_OBJECT
public:
    enum QuantizerType { Grid, Legato, Notation };

    QuantizeParameters(TQWidget *parent,
                       QuantizerType defaultQuantizer,
                       bool showNotationOption,
                       bool showAdvancedButton,
                       TQString configCategory,
                       TQString preamble = 0);
    
    /**
     * Returned quantizer object is on heap -- caller must delete.
     * Also writes values to KConfig if so requested in constructor.
     */
    Quantizer *getQuantizer() const;

    TQWidget *getAdvancedWidget() { return m_postProcessingBox; }

    bool shouldRebeam() const { return m_rebeam; }
    bool shouldDeCounterpoint() const { return m_deCounterpoint; }
    bool shouldMakeViable() const { return m_makeViable; }

    void showAdvanced(bool show);

public slots:
    void slotTypeChanged(int);
    void slotAdvancedChanged();

protected:
    TQString m_configCategory;

    std::vector<timeT> m_standardQuantizations;

    TQGridLayout *m_mainLayout;

    KComboBox *m_typeCombo;

    TQGroupBox *m_gridBox;
    TQCheckBox *m_durationCheckBox;
    KComboBox *m_gridUnitCombo;
    TQLabel    *m_swingLabel;
    KComboBox *m_swingCombo;
    TQLabel    *m_iterativeLabel;
    KComboBox *m_iterativeCombo;

    TQGroupBox *m_notationBox;
    TQCheckBox *m_notationTarget;
    KComboBox *m_notationUnitCombo;
    KComboBox *m_simplicityCombo;
    KComboBox *m_maxTuplet;
    TQCheckBox *m_counterpoint;

    TQPushButton *m_advancedButton;
    TQGroupBox *m_postProcessingBox;
    TQCheckBox *m_articulate;
    TQCheckBox *m_makeViable;
    TQCheckBox *m_deCounterpoint;
    TQCheckBox *m_rebeam;
};



}

#endif
