/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "PropertyBox.h"

#include "gui/general/GUIPalette.h"
#include <tqpainter.h>
#include <tqsize.h>
#include <tqstring.h>
#include <tqwidget.h>


namespace Rosegarden
{

PropertyBox::PropertyBox(TQString label,
                         int width,
                         int height,
                         TQWidget *parent,
                         const char *name):
        TQWidget(parent, name),
        m_label(label),
        m_width(width),
        m_height(height)
{}

QSize
PropertyBox::sizeHint() const
{
    return TQSize(m_width, m_height);
}

QSize
PropertyBox::minimumSizeHint() const
{
    return TQSize(m_width, m_height);
}

void
PropertyBox::paintEvent(TQPaintEvent *e)
{
    TQPainter paint(this);

    paint.setPen(GUIPalette::getColour(GUIPalette::MatrixElementBorder));
    //paint.setBrush(GUIPalette::getColour(GUIPalette::MatrixElementBlock));

    paint.setClipRegion(e->region());
    paint.setClipRect(e->rect().normalize());

    paint.drawRect(2, 2, m_width - 3, m_height - 3);
    paint.drawText(10, 2 * m_height / 3, m_label);
}

}
#include "PropertyBox.moc"
