/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "QCanvasMatrixDiamond.h"

#include "MatrixElement.h"
#include "QCanvasMatrixRectangle.h"
#include <tqcanvas.h>
#include <tqpainter.h>
#include <tqpointarray.h>
#include <tqpoint.h>


namespace Rosegarden
{

QCanvasMatrixDiamond::QCanvasMatrixDiamond(MatrixElement &n,
        TQCanvas* canvas) :
        QCanvasMatrixRectangle(n, canvas)
{}

QCanvasMatrixDiamond::~QCanvasMatrixDiamond()
{
    hide();
}

TQPointArray QCanvasMatrixDiamond::areaPoints() const
{
    TQPointArray pa(4);
    int pw = (pen().width() + 1) / 2;
    if ( pw < 1 )
        pw = 1;
    if ( pen() == NoPen )
        pw = 0;
    pa[0] = TQPoint((int)x() - height() / 2 - pw, (int)y() - pw);
    pa[1] = pa[0] + TQPoint(height() + pw * 2, 0);
    pa[2] = pa[1] + TQPoint(0, height() + pw * 2);
    pa[3] = pa[0] + TQPoint(0, height() + pw * 2);
    return pa;
}

void QCanvasMatrixDiamond::drawShape(TQPainter & p)
{
    p.save();
    p.setWorldXForm(false);

    TQPointArray pa(4);
    int q = height() / 2 + 2;
    TQPoint mapPos = p.worldMatrix().map(TQPoint(int(x()), int(y())));

    pa[0] = TQPoint(mapPos.x(), mapPos.y() - 3);
    pa[1] = TQPoint(mapPos.x() + q, mapPos.y() - 3 + q);
    pa[2] = pa[0] + TQPoint(0, q * 2);
    pa[3] = pa[1] - TQPoint(q * 2, 0);
    p.drawConvexPolygon(pa);

    p.restore();
}

}
