/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_CHORD_H_
#define _RG_CHORD_H_

#include "Fingering.h"
#include "base/Event.h"
#include "misc/Debug.h"

#include <vector>
#include <tqstring.h>
#include <tqregexp.h>

namespace Rosegarden
{

class Event;

namespace Guitar
{
    
class Chord
{
    friend bool operator<(const Chord&, const Chord&);
    
public:
    static const std::string EventType;
    static const short EventSubOrdering;
    static const PropertyName RootPropertyName;
    static const PropertyName ExtPropertyName;
    static const PropertyName FingeringPropertyName;

	Chord();
    Chord(const TQString& root, const TQString& ext = TQString::null);
    Chord(const Event&);

    Event* getAsEvent(timeT absoluteTime) const;
        
    bool isEmpty() const   { return m_root.isEmpty(); }
    bool operator!() const { return !m_root; }
    
    bool isUserChord() const { return m_isUserChord; }
    void setUserChord(bool c) { m_isUserChord = c; }
     
    TQString getRoot() const { return m_root; }
    void setRoot(TQString r) { m_root = r; } 

    TQString getExt() const { return m_ext; }
    void setExt(TQString r) { m_ext = r.isEmpty() ? TQString::null : r; } 
    
    bool hasAltBass() const { return m_ext.contains(ALT_BASS_REGEXP); } 

    Fingering getFingering() const { return m_fingering; }
    void setFingering(Fingering f) { m_fingering = f; }

    struct ChordCmp
    {
        bool operator()(const Chord &e1, const Chord &e2) const {
            return e1 < e2;
        }
        bool operator()(const Chord *e1, const Chord *e2) const {
            return *e1 < *e2;
        }
    };
        
protected:

    static const TQRegExp ALT_BASS_REGEXP;
    
    TQString m_root;
    TQString m_ext;
    
    Fingering m_fingering;
    
    bool m_isUserChord;
};

bool operator<(const Chord&, const Chord&);    

}

}

#endif /*_RG_CHORD2_H_*/
