
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_TEXTEVENTDIALOG_H_
#define _RG_TEXTEVENTDIALOG_H_

#include "base/NotationTypes.h"
#include <string>
#include <kdialogbase.h>
#include <tqstring.h>
#include <vector>


class TQWidget;
class TQLineEdit;
class TQLabel;
class KComboBox;
class TQSpinBox;

namespace Rosegarden
{

class NotePixmapFactory;


class TextEventDialog : public KDialogBase
{
    Q_OBJECT

public:
    TextEventDialog(TQWidget *parent,
                    NotePixmapFactory *npf,
                    Text defaultText,
                    int maxLength = -1); // for Qt default

    Text getText() const;

public slots:
    void slotTextChanged(const TQString &);
    void slotTypeChanged(const TQString &);

    /*
     * Save previous state of assorted widgets for restoration in the next
     * instance
     */
    void slotOK();

    // convenience canned texts
    void slotDynamicShortcutChanged(const TQString &);
    void slotDirectionShortcutChanged(const TQString &);
    void slotLocalDirectionShortcutChanged(const TQString &);
    void slotTempoShortcutChanged(const TQString &);
    void slotLocalTempoShortcutChanged(const TQString &);

    //
    // special LilyPond directives, initial phase, as cheap text events; will
    // eventually move out of Text, and out of this dialog into
    // some other less cheesy interface 
    //
    void slotLilyPondDirectiveChanged(const TQString &);

protected:

    std::string getTextType() const;
    std::string getTextString() const;

    //--------------- Data members ---------------------------------

    TQLineEdit *m_text;
    KComboBox *m_typeCombo;
    TQSpinBox  *m_verseSpin;
    KComboBox *m_dynamicShortcutCombo;
    KComboBox *m_directionShortcutCombo;
    KComboBox *m_localDirectionShortcutCombo;
    KComboBox *m_tempoShortcutCombo;
    KComboBox *m_localTempoShortcutCombo;
    // temporary home:
    KComboBox *m_lilyPondDirectiveCombo;


    TQLabel *m_staffAboveLabel;
    TQLabel *m_textExampleLabel;
    TQLabel *m_staffBelowLabel;
    TQLabel *m_dynamicShortcutLabel;
    TQLabel *m_directionShortcutLabel;
    TQLabel *m_localDirectionShortcutLabel;
    TQLabel *m_tempoShortcutLabel;
    TQLabel *m_localTempoShortcutLabel;
    TQLabel *m_verseLabel;
    // temporary home:
    TQLabel *m_directiveLabel;

    TQString m_prevChord;
    TQString m_prevLyric;
    TQString m_prevAnnotation;

    NotePixmapFactory *m_notePixmapFactory;
    std::vector<std::string> m_styles;
//    std::vector<std::string> m_directives;

};



}

#endif
