/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "ShowSequencerStatusDialog.h"

#include <klocale.h>
#include <kdialogbase.h>
#include <tqcstring.h>
#include <tqdatastream.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqtextedit.h>
#include <tqvbox.h>
#include <tqwidget.h>
#include "gui/application/RosegardenApplication.h"


namespace Rosegarden
{

ShowSequencerStatusDialog::ShowSequencerStatusDialog(TQWidget *parent) :
        KDialogBase(parent, 0, true, i18n("Sequencer status"), Close)
{
    TQVBox *vbox = makeVBoxMainWidget();

    new TQLabel(i18n("Sequencer status:"), vbox);

    TQString status(i18n("Status not available."));

    TQCString replyType;
    TQByteArray replyData;
    TQByteArray data;

    if (!rgapp->sequencerCall("getStatusLog()", replyType, replyData)) {
        status = i18n("Sequencer is not running or is not responding.");
    }

    TQDataStream streamIn(replyData, IO_ReadOnly);
    TQString result;
    streamIn >> result;
    if (!result) {
        status = i18n("Sequencer is not returning a valid status report.");
    } else {
        status = result;
    }

    TQTextEdit *text = new TQTextEdit(vbox);
    text->setTextFormat(Qt::PlainText);
    text->setReadOnly(true);
    text->setMinimumWidth(500);
    text->setMinimumHeight(200);

    text->setText(status);
}

}
#include "ShowSequencerStatusDialog.moc"
