/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CRESMGR_H
#define CRESMGR_H

//Qt includes
#include <tqstring.h>
#include <tqkeysequence.h>

//KDE includes
#include <kshortcut.h>

/** Provides static functions to easily access the Tooltip texts for all the frontend parts.
  * @author The BibleTime team
  */
namespace CResMgr {
	void init_i18n();

	namespace modules {
		namespace bible {
			extern const TQString icon_unlocked;
			extern const TQString icon_locked;
			extern const TQString icon_add;
		}
		namespace commentary {
			extern const TQString icon_unlocked;
			extern const TQString icon_locked;
			extern const TQString icon_add;
		};
		namespace lexicon {
			extern const TQString icon_unlocked;
			extern const TQString icon_locked;
			extern const TQString icon_add;
		};
		namespace book {
			extern const TQString icon_unlocked;
			extern const TQString icon_locked;
			extern const TQString icon_add;
		};
	};

	namespace mainMenu { //Main menu
		namespace file { //Main menu->File
			namespace print { //a standard action
				extern TQString tooltip;

			}
			namespace quit { //a standard action
				extern TQString tooltip;
			}
		}

		namespace view { //Main menu->View
			namespace showMainIndex {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace showInfoDisplay {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace showToolBar { //a standard action
				extern TQString tooltip;
			}
		}

		namespace mainIndex { //configuration for the main index and the view->search menu
			namespace search {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace searchdefaultbible {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
		}

		namespace window { //Main menu->Window
			namespace loadProfile {
				extern TQString tooltip;

				extern const TQString icon;
				extern const char* actionName;
			}
			namespace saveProfile {
				extern TQString tooltip;

				extern const TQString icon;
				extern const char* actionName;
			}
			namespace saveToNewProfile {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace deleteProfile {
				extern TQString tooltip;

				extern const TQString icon;
				extern const char* actionName;
			}
			namespace showFullscreen {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace arrangementMode {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;

				namespace manual {
					extern TQString tooltip;

					extern const TQString icon;
					extern const KShortcut accel;
					extern const char* actionName;
				}
				namespace autoTileVertical {
					extern TQString tooltip;

					extern const TQString icon;
					extern const KShortcut accel;
					extern const char* actionName;
				}
				namespace autoTileHorizontal {
					extern TQString tooltip;

					extern const TQString icon;
					extern const KShortcut accel;
					extern const char* actionName;
				}
				namespace autoCascade {
					extern TQString tooltip;

					extern const TQString icon;
					extern const KShortcut accel;
					extern const char* actionName;
				}
			}
			namespace tileVertical {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace tileHorizontal {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace cascade {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace closeAll {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
		}

		namespace settings { //Main menu->Settings
			namespace editToolBar { // available as KStdAction
				extern TQString tooltip;

			}
			namespace optionsDialog { // available as KStdAction
				extern TQString tooltip;

			}
			namespace swordSetupDialog {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
		}

		namespace help { //Main menu->Help
			namespace handbook {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace bibleStudyHowTo {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace bugreport { // available as KStdAction
				extern TQString tooltip;
			}
			namespace dailyTip {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace aboutBibleTime { // available as KStdAction
				extern TQString tooltip;
			}
			namespace aboutKDE { // available as KStdAction
				extern TQString tooltip;
			}
		}
	}  //end of main menu

	namespace searchdialog {
		extern const TQString icon;

		namespace searchButton {
			extern TQString tooltip;
		}
		namespace cancelSearchButton {
			extern TQString tooltip;
		}

		namespace options {
			namespace moduleChooserButton {
				extern TQString tooltip;
			}
			namespace searchedText {
				extern TQString tooltip;
			}
			namespace searchType {
				namespace multipleWords_and {
					extern TQString tooltip;
				}
				namespace multipleWords_or {
					extern TQString tooltip;
				}
				namespace exactMatch {
					extern TQString tooltip;
				}
				namespace regExp {
					extern TQString tooltip;
				}
			}

			namespace searchOptions {
				namespace caseSensitive {
					extern TQString tooltip;
				}
			}
			namespace chooseScope {
				extern TQString tooltip;
			}
			namespace scopeEditor {
				namespace rangeList {
					extern TQString tooltip;
				}
				namespace nameEdit {
					extern TQString tooltip;
				}
				namespace editRange {
					extern TQString tooltip;
				}
				namespace parsedResult {
					extern TQString tooltip;
				}
				namespace addNewRange {
					extern TQString tooltip;
				}
				namespace deleteCurrentRange {
					extern TQString tooltip;
				}

			}
		}
		namespace result {
			namespace moduleList {
				extern TQString tooltip;

				namespace copyMenu {
					extern const TQString icon;
				}
				namespace saveMenu {
					extern const TQString icon;
				}
				namespace printMenu {
					extern const TQString icon;
				}
			}
			namespace foundItems {
				extern TQString tooltip;

				namespace copyMenu {
					extern const TQString icon;
				}
				namespace saveMenu {
					extern const TQString icon;
				}
				namespace printMenu {
					extern const TQString icon;
				}

			}
			namespace textPreview {
				extern TQString tooltip;
			}
		}
	}

namespace workspace {}

	namespace displaywindows {
		namespace transliteration {
			extern const TQString icon;
		}
		namespace displaySettings {
			extern const TQString icon;
		}

		namespace general {
			namespace scrollButton {
				extern TQString tooltip;
			}
			namespace search {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}

			namespace backInHistory {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace forwardInHistory {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}

			namespace findStrongs {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
		}

		namespace bibleWindow {
			namespace bookList {
				extern TQString tooltip;

			}
			namespace nextBook {
				extern TQString tooltip;

				extern const KShortcut accel;
			}
			namespace previousBook {
				extern TQString tooltip;

				extern const KShortcut accel;
			}

			namespace chapterList {
				extern TQString tooltip;

			}
			namespace nextChapter {
				extern TQString tooltip;

				extern const KShortcut accel;
			}
			namespace previousChapter {
				extern TQString tooltip;

				extern const KShortcut accel;
			}

			namespace verseList {
				extern TQString tooltip;

			}
			namespace nextVerse {
				extern TQString tooltip;

				extern const KShortcut accel;
			}
			namespace previousVerse {
				extern TQString tooltip;

				extern const KShortcut accel;
			}
			
			namespace copyMenu {
				extern const TQString icon;
			}
			namespace saveMenu {
				extern const TQString icon;
			}
			namespace printMenu {
				extern const TQString icon;
			}
		}
		namespace commentaryWindow {
			namespace syncWindow {
				extern const TQString icon;
				extern TQString tooltip;

				extern const KShortcut accel;
				extern const char* actionName;
			}

		}

		namespace lexiconWindow {
			namespace entryList {
				extern TQString tooltip;

			}
			namespace nextEntry {
				extern TQString tooltip;

				extern const KShortcut accel;
			}
			namespace previousEntry {
				extern TQString tooltip;

				extern const KShortcut accel;
			}

			namespace copyMenu {
				extern const TQString icon;
			}
			namespace saveMenu {
				extern const TQString icon;
			}
			namespace printMenu {
				extern const TQString icon;
			}
		}
		namespace bookWindow {
			namespace toggleTree {
				extern const TQString icon;
				extern const KShortcut accel;
			}
		}


		namespace writeWindow {
			namespace saveText {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace restoreText {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace deleteEntry {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}

			//formatting buttons
			namespace boldText {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace italicText {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace underlinedText {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}

			namespace alignLeft {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace alignCenter {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace alignRight {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace alignJustify {
				extern TQString tooltip;

				extern const TQString icon;
				extern const KShortcut accel;
				extern const char* actionName;
			}

			namespace fontFamily {
				extern TQString tooltip;

				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace fontSize {
				extern TQString tooltip;

				extern const KShortcut accel;
				extern const char* actionName;
			}
			namespace fontColor {
				extern TQString tooltip;

			}

		}
	}

	namespace settings {
		namespace startup {
			extern const TQString icon;

			namespace dailyTip {
				extern TQString tooltip;

			}
			namespace showLogo {
				extern TQString tooltip;

			}
			namespace restoreWorkingArea {
				extern TQString tooltip;

			}
		}
		namespace fonts {
			extern const TQString icon;

			namespace typeChooser {
				extern TQString tooltip;

			}
		}
		namespace profiles {
			extern const TQString icon;

			namespace list {
				extern TQString tooltip;

			}
			namespace createNew {
				extern TQString tooltip;

			}
			namespace deleteCurrent {
				extern TQString tooltip;

			}
			namespace renameCurrent {
				extern TQString tooltip;

			}
		}
		namespace sword {
			extern const TQString icon;

			namespace general {

				namespace language {
					extern TQString tooltip;
				}
			}
			namespace modules {
				namespace bible {
					extern TQString tooltip;
				}
				namespace commentary {
					extern TQString tooltip;
				}
				namespace lexicon {
					extern TQString tooltip;
				}
				namespace dailyDevotional {
					extern TQString tooltip;
				}
				namespace hebrewStrongs {
					extern TQString tooltip;
				}
				namespace greekStrongs {
					extern TQString tooltip;
				}
				namespace hebrewMorph {
					extern TQString tooltip;
				}
				namespace greekMorph {
					extern TQString tooltip;
				}
			}
		}
		namespace keys {
			extern const TQString icon;
		}
	}

	namespace mainIndex { //configuration for the main index and the view->search menu
		namespace search {
			extern TQString tooltip;

			extern const TQString icon;
			extern const KShortcut accel;
			extern const char* actionName;
		}
		namespace newFolder {
			extern const TQString icon;
		}
		namespace changeFolder {
			extern const TQString icon;
		}
		namespace openedFolder {
			extern const TQString icon;
		}
		namespace closedFolder {
			extern const TQString icon;
		}

		namespace bookmark {
			extern const TQString icon;
		}
		namespace changeBookmark {
			extern const TQString icon;
		}
		namespace importBookmarks {
			extern const TQString icon;
		}
		namespace exportBookmarks {
			extern const TQString icon;
		}
		namespace printBookmarks {
			extern const TQString icon;
		}
		namespace deleteItems {
			extern const TQString icon;
		}

		namespace editModuleMenu {
			extern const TQString icon;
		}
		namespace editModulePlain {
			extern const TQString icon;
		}
		namespace editModuleHTML {
			extern const TQString icon;
		}

		namespace unlockModule {
			extern const TQString icon;
		}
		namespace aboutModule {
			extern const TQString icon;
		}
	}
}

#endif
