/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CRANGECHOOSER_H
#define CRANGECHOOSER_H

//BibleTime includes
#include "backend/cswordmoduleinfo.h"
#include "backend/cswordbackend.h"

#include "util/cpointers.h"

//Sword includes


//Qt includes
#include <tqwidget.h>
#include <tqstring.h>
#include <tqcanvas.h>
#include <tqdict.h>
#include <tqtooltip.h>

//KDE includes
#include <kdialog.h>
#include <kdialogbase.h>
#include <klistview.h>

//forward declarations
class CSearchAnalysisItem;
class CSearchAnalysisLegendItem;
class CSearchAnalysis;
class CSearchAnalysisView; 

class TQTextEdit;

namespace Search {
	namespace Options {
	
class CRangeChooserDialog : public KDialogBase {
	Q_OBJECT
public:
	CRangeChooserDialog(TQWidget* parentDialog);
	~CRangeChooserDialog();

protected: // Protected methods
class RangeItem : public KListViewItem {
public:
		RangeItem(TQListView*, TQListViewItem* afterThis = 0, const TQString caption = TQString::null, const TQString range = TQString::null);
		~RangeItem();
		const TQString& range();
		const TQString caption();
		void setRange(TQString range);
		void setCaption(const TQString);
private:
		TQString m_range;
	};

	/**
	* Initializes the connections of this widget.
	*/
	void initConnections();
	/**
	* Initializes the view of this object.
	*/
	void initView();

protected slots: // Protected slots
	/**
	* Adds a new range to the list.
	*/
	void addNewRange();
	void editRange(TQListViewItem*);
	/**
	* Parses the entered text and prints out the result in the list box below the edit area.
	*/
	void parseRange();
	void nameChanged(const TQString&);
	void rangeChanged();
	/**
	* Deletes the selected range.
	*/
	void deleteCurrentRange();
	virtual void slotDefault();
	virtual void slotOk();

private:
	KListView* m_rangeList;
	KListView* m_resultList;
	TQLineEdit* m_nameEdit;
	TQTextEdit* m_rangeEdit;
	TQPushButton* m_newRangeButton;
	TQPushButton* m_deleteRangeButton;
};

	} //end of namespace Search.Options
} //end of namespace Search

#endif
