/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



//Own includes
#include "kstartuplogo.h"

//Qt includes
#include <tqapplication.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpixmap.h>

//KDE includes
#include <kapplication.h>
#include <kstandarddirs.h>
//#include <kimageio.h>

//static objects
KStartupLogo* KStartupLogo::startupLogo = 0;

void KStartupLogo::createSplash() {
	deleteSplash();
	startupLogo = new KStartupLogo();
}

void KStartupLogo::showSplash() {
	if (KStartupLogo::startupLogo) {
		KStartupLogo::startupLogo->show();
	}
}

void KStartupLogo::hideSplash() {
	if (startupLogo) {
		startupLogo->hide();
	}
}

void KStartupLogo::deleteSplash() {
	delete startupLogo;
	startupLogo = 0;
}


void KStartupLogo::setStatusMessage(const TQString& message) {
	if (startupLogo) {
		startupLogo->setText(message);
	}
}

KStartupLogo::KStartupLogo()
: TQWidget(0, "startuplogo", /*WStyle_Customize | WStyle_NoBorder*/ WStyle_NoBorder|WStyle_StaysOnTop|WX11BypassWM ) {

	TQPixmap pm;
	if ( !pm.load(locate("BT_pic","startuplogo.png")) ) {
		qWarning("Can't load startuplogo! Check your installation.");
	}

	setBackgroundPixmap(pm);

	//Please not change the margin
	textLabel = new TQLabel(this);
	textLabel->setGeometry(0,pm.height(),pm.width(),textLabel->sizeHint().height()+10);
	textLabel->setBackgroundColor( TQColor("#0d6de9") );
	textLabel->setFrameStyle(TQFrame::Panel | TQFrame::Plain);
	textLabel->setLineWidth(1);
	textLabel->setScaledContents( true );

	TQFont f;
	f.setBold( true );
	textLabel->setFont( f );

	TQPalette p = palette();
	p.setColor( TQPalette::Inactive, TQColorGroup::Text, Qt::white );
	p.setColor( TQPalette::Inactive, TQColorGroup::Foreground, Qt::white );
	p.setColor( TQPalette::Normal, TQColorGroup::Text, Qt::white );
	p.setColor( TQPalette::Normal, TQColorGroup::Foreground, Qt::white );
	setPalette( p );

	setGeometry (
		(KApplication::desktop()->width()-pm.width())/2,
		(KApplication::desktop()->height()-pm.height()-textLabel->height())/2,
		pm.width(),
		pm.height()+textLabel->height()
	);
}

void KStartupLogo::setText(const TQString text) {
	//Please not make the text bold & let the first character be blank
	textLabel->setText( TQString::fromLatin1(" %1").arg(text) );
	KApplication::kApplication()->processEvents();
}

/** Makes the splashscreen the toplevel window. */
void KStartupLogo::raiseSplash() {
	if (startupLogo) {
		startupLogo->raise();
		startupLogo->setActiveWindow();
		startupLogo->textLabel->show();
	}
}

/** Lowers the splash screen one window down, so it's possible to make it not to hide tip windows or other startup stuff. */
void KStartupLogo::lowerSplash() {
	if (startupLogo) {
		startupLogo->lower();
	}
}
