/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CKEYREFERENCEWIDGET_H
#define CKEYREFERENCEWIDGET_H

#include "cscrollerwidgetset.h"
#include "backend/cswordbiblemoduleinfo.h"

#include <tqwidget.h>
#include <tqlayout.h>

#include <klineedit.h>
#include <kcompletion.h>

class CLexiconKeyChooser;
class CSwordVerseKey;

class CKeyReferenceCompletion : public KCompletion {
    Q_OBJECT
public:
    CKeyReferenceCompletion(CSwordBibleModuleInfo*);
    TQString makeCompletion(const TQString &);
    TQStringList allMatches();
private:
    CSwordVerseKey *m_key;
    CSwordBibleModuleInfo *m_module;
};

class CKeyReferenceLineEdit : public KLineEdit {
    Q_OBJECT
public:
    CKeyReferenceLineEdit(TQWidget *parent=0, const char *name=0);
    void makeCompletion(const TQString &);
};

class CKeyReferenceWidget : public TQWidget  {
    Q_OBJECT
public:
    /**
    * the constructor
    */
    CKeyReferenceWidget(CSwordBibleModuleInfo *, CSwordVerseKey*, TQWidget *parent=0, const char *name=0);
    bool setKey(CSwordVerseKey* key);
    KLineEdit* textbox();
    void setModule(CSwordBibleModuleInfo *m = 0);

signals:
    void changed(CSwordVerseKey* key);

protected:
    void updateText();

protected slots: // Protected slots
    /**
    * Is called when the return key was presed in the textbox.
    */
    void slotReturnPressed();

    void slotClearRef();

    void slotUpdateLock();
    void slotUpdateUnlock();
    void slotBookChange(int);
    void slotChapterChange(int);
    void slotVerseChange(int);

private:
    friend class CLexiconKeyChooser;
    TQHBoxLayout *m_mainLayout;
    CKeyReferenceLineEdit *m_textbox;
    CSwordVerseKey *m_key;
    CScrollerWidgetSet *m_bookScroller;
    CScrollerWidgetSet *m_chapterScroller;
    CScrollerWidgetSet *m_verseScroller;
    bool updatelock;
    TQString oldKey;
    CSwordBibleModuleInfo *m_module;
};

#endif
