/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CPLAINWRITEDISPLAY_H
#define CPLAINWRITEDISPLAY_H

//Bibletime include files
#include "cwritedisplay.h"

//Qt includes
#include <tqwidget.h>
#include <tqtextedit.h>

class CHTMLWriteDisplay;
class KAction;

/** The write display implementation for plain source code editing.
  * @author The BibleTime team
  */
class CPlainWriteDisplay : public TQTextEdit, public CWriteDisplay  {
public:
	/**
	* Reimplementation.
	*/
	virtual void selectAll();
	/**
	* Sets the new text for this display widget.
	*/
	virtual void setText( const TQString& newText );
	/**
	* Returns true if the display widget has a selection. Otherwise false.
	*/
	virtual const bool hasSelection();
	/**
	* Returns the view of this display widget.
	*/
	virtual TQWidget* view();
	virtual const TQString text( const CDisplay::TextType format = CDisplay::HTMLText, const CDisplay::TextPart part = CDisplay::Document );
	virtual void print( const CDisplay::TextPart, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions );
	/**
	* Reimplementation.
	*/
	virtual const bool isModified() const;
	/**
	* Sets the current status of the edit widget.
	*/
	virtual void setModified( const bool modified );
	/**
	* Returns the text of this edit widget.
	*/
	virtual const TQString plainText();
	/**
	* Creates the necessary action objects and puts them on the toolbar.
	*/
	virtual void setupToolbar(KToolBar * bar, KActionCollection * actionCollection);

protected:
	friend class CDisplay;
	friend class CHTMLWriteDisplay;

	CPlainWriteDisplay(CWriteWindow* parentWindow, TQWidget* parent);
	virtual ~CPlainWriteDisplay();
	/**
	* Reimplementation from TQTextEdit. Provides an popup menu for the given position.
	*/
	virtual TQPopupMenu* createPopupMenu( const TQPoint& pos );
	/**
	* Reimplementation from TQTextEdit. Provides an popup menu.
	*/
	virtual TQPopupMenu* createPopupMenu();
	/**
	* Reimplementation to manage drops of our drag and drop objects.
	*/
	virtual void contentsDropEvent( TQDropEvent* e );
	/**
	* Reimplementation to insert the text of a dragged reference into the edit view.
	*/
	virtual void contentsDragEnterEvent( TQDragEnterEvent* e );
	/**
	* Reimplementation to insert the text of a dragged reference into the edit view.
	*/
	virtual void contentsDragMoveEvent( TQDragMoveEvent* e );

};

#endif
