/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



//own includes
#include "cinputdialog.h"

//Qt includes
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqtextedit.h>
#include <tqpushbutton.h>
#include <tqlayout.h>

//KDE includes
#include <klocale.h>
#include <kseparator.h>

CInputDialog::CInputDialog(const TQString& caption, const TQString& description, const TQString& text, TQWidget *parent, const char *name, const bool modal ) : KDialog(parent,name,modal) {
	setPlainCaption(caption);

	TQVBoxLayout* topLayout = new TQVBoxLayout(this, 5,5);

	TQLabel* l = new TQLabel(description, this);
	topLayout->addWidget(l);

	topLayout->addSpacing(10);

	m_editWidget = new TQTextEdit(this, "edit widget");
	m_editWidget->setWordWrap( TQTextEdit::WidgetWidth );
	m_editWidget->setText(text);
	if (!text.isEmpty())
		m_editWidget->selectAll();

	topLayout->addWidget(m_editWidget);

	KSeparator* separator = new KSeparator(KSeparator::HLine, this);
	topLayout->addWidget(separator);

	TQHBoxLayout* buttonLayout = new TQHBoxLayout(topLayout);

	buttonLayout->addStretch(2);

	TQPushButton* cancel = new TQPushButton(this);
	cancel->setText(i18n("&Cancel"));
	connect(cancel, TQT_SIGNAL(clicked()), TQT_SLOT(reject()));
	buttonLayout->addWidget(cancel,1);

	buttonLayout->addSpacing(15);

	TQPushButton* clear = new TQPushButton(this);
	clear->setText(i18n("C&lear"));
	connect(clear, TQT_SIGNAL(clicked()),m_editWidget, TQT_SLOT(clear()));
	buttonLayout->addWidget(clear,1);

	buttonLayout->addSpacing(15);

	TQPushButton* ok = new TQPushButton(this);
	ok->setText(i18n("&Ok"));
	connect(ok, TQT_SIGNAL(clicked()), TQT_SLOT(accept()));
	buttonLayout->addWidget(ok,1);

	m_editWidget->setFocus();
}

/** Returns the text entered at the moment. */
const TQString CInputDialog::text() {
	return m_editWidget->text();
}

/** A static function to get some using CInputDialog. */
const TQString CInputDialog::getText( const TQString& caption, const TQString& description, const TQString& text, bool* ok, TQWidget* parent, bool modal) {
	CInputDialog* dlg = new CInputDialog(caption, description, text, parent, "", modal);
	TQString ret = TQString::null;

	const bool isOk = (dlg->exec() == CInputDialog::Accepted);
	if (isOk) {
		ret = dlg->text();
	}

	if (ok) { //change the ok param to return the value
		*ok = isOk;
	}

	delete dlg;
	return ret;
}
