//
// C++ Interface: cdisplaytemplatemgr
//
// Description:
//
//
// Author: The BibleTime team <info@bibletime.info>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CDISPLAYTEMPLATEMGR_H
#define CDISPLAYTEMPLATEMGR_H

//BibleTime include
#include "cswordmoduleinfo.h"

//Qt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqstringlist.h>

//KDE includes
#include <klocale.h>

/**
 * Manages the display templates used in the filters and display classes.
 * @author The BibleTime team
*/

class CDisplayTemplateMgr {

public:
    /** Settings which are used to fill the content into the template.
    */

    struct Settings {
        /** Constructor. Constructs the new settings object. The default values are empty.
         */
        Settings() {
            title = TQString::null;
            langAbbrev = TQString::null;
            pageCSS_ID = TQString::null;
            pageDirection = TQString("ltr");
        };

        ListCSwordModuleInfo modules; /**< the list of modules */
        TQString title; /**< the title which is used for the new processed HTML page */
        TQString langAbbrev; /**< the language for the HTML page. */
        TQString pageDirection; /**< the language for the HTML page. */
        TQString pageCSS_ID; /**< the CSS ID which is used in the content part of the page */
    };

    /** Available templates.
    * @return The list of templates, which are available.
    */
    inline const TQStringList availableTemplates();
    /** Fill template. Fill rendered content into the template given by the name.
    * @param name The name of the template
    * @param content The content which should be filled into the template
    * @param settings The settings which are used to process the templating process
    * @return The full HTML template HTML code including the CSS data.
    */
    const TQString fillTemplate( const TQString& name, const TQString& content, Settings& settings);
    /** Default template.
    * @return The i18n'ed name of the default template
    */
    inline static const TQString defaultTemplate();

protected:

    friend class CPointers;
    /** Display template manager constructor. Protected to just allow CPointers to create objects.
    */
    CDisplayTemplateMgr();
    /** Destructor.
    */
    ~CDisplayTemplateMgr();

    void loadUserTemplates();

private:
    void init();
    TQMap<TQString, TQString> m_templateMap;
};

inline const TQString CDisplayTemplateMgr::defaultTemplate() {
    return i18n("Default");
}

/**
 * CDisplayTemplateMgr::availableTemplates()
 */
inline const TQStringList CDisplayTemplateMgr::availableTemplates() {
    return m_templateMap.keys();
}



#endif
