/*
 *  Copyright (c) 1998 Denis Perchine <dyp@perchine.com>
 *  Copyright (c) 2004 Szombathelyi György <gyurco@freemail.hu>
 *  Maintained by Adriaan de Groot <groot@kde.org>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef _KU_GROUP_H_
#define _KU_GROUP_H_

#include <sys/types.h>

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>

#include "kuserprefs.h"
#include "sid.h"

namespace KU {

class KGroup {
public:
  KGroup();
  KGroup(KGroup *group);
  ~KGroup();

  enum Cap {
    Cap_Samba = 1
  };

  void copy(const KGroup *group);
  void setCaps( int data );
  int getCaps();

  const TQString &getName() const;
  const TQString &getPwd() const;
  gid_t getGID() const;
  const SID &getSID() const;
  int getType() const;
  const TQString &getDisplayName() const;
  const TQString &getDesc() const;

  void setName(const TQString &data);
  void setPwd(const TQString &data);
  void setGID(gid_t data);
  void setSID(const SID &data);
  void setType(int data);
  void setDisplayName(const TQString &data);
  void setDesc(const TQString &data);

  bool addUser(const TQString &name);
  bool removeUser(const TQString &name);
  bool lookup_user(const TQString &name);
  uint count() const;
  TQString user(uint i);
  void clear();

protected:
  QString
    name,
    pwd;
  gid_t gid;

//samba attributes  
  SID sid;
  int type;
  int caps;
  TQString displayname;
  TQString desc;
  
  TQStringList u;
};

class KGroups {
public:
  enum Cap {
    Cap_ReadOnly = 1,
    Cap_Passwd = 2,
    Cap_Shadow = 4,
    Cap_Samba = 8
  };

  typedef TQPtrListIterator<KGroup> DelIt;
  typedef TQPtrListIterator<KGroup> AddIt;
  typedef TQMapIterator<KGroup*, KGroup> ModIt;
  
  TQPtrList<KGroup> mDelSucc;
  TQPtrList<KGroup> mAddSucc;
  TQMap<KGroup*, KGroup> mModSucc;
  
  KGroups( KUserPrefsBase *cfg );
  virtual ~KGroups();
  
  int getCaps() const { return caps; }
  const TQString &getDOMSID() const;

  KGroup *lookup( const TQString &name );
  KGroup *lookup( gid_t gid );
  KGroup *lookup_sam( const SID &sid );
  KGroup *lookup_sam( const TQString &sid );
  KGroup *lookup_sam( uint rid );
  
  KGroup *first();
  KGroup *next();
  KGroup *operator[](uint num);
  uint count() const;

  void add(KGroup *group);
  void del(KGroup *group);
  void mod(KGroup *gold, const KGroup &gnew);
  void commit();
  void cancelMods();
  
  enum {
	NO_FREE = (gid_t) -1
  };

  virtual gid_t first_free();
  virtual uint first_free_sam();
  virtual bool reload() = 0;
  virtual bool dbcommit() = 0;

protected:
  KUserPrefsBase *mCfg;
  TQPtrList<KGroup> mGroups;
  
  TQPtrList<KGroup> mDel;
  TQPtrList<KGroup> mAdd;
  TQMap<KGroup*, KGroup> mMod;
  int caps;
  TQString domsid;
};

}

#endif // _KU_GROUP_H_
