/***************************************************************************
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSV_TRASH_H
#define KSV_TRASH_H

#include <tqframe.h>
#include <tqpixmap.h>
#include <tqstring.h>

// forward declarations
class TQLabel;
class KIconLoader;
class KSVItem;
class KSVAction;

class KSVTrash : public QFrame
{
  Q_OBJECT
  
public:
  KSVTrash (TQWidget* parent = 0, const char* name = 0);
  virtual ~KSVTrash();
  
  virtual TQSize sizeHint() const;

protected:
  /**
   * Overridden from @ref QDropSite
   */
  virtual void dragMoveEvent ( TQDragMoveEvent* );
  
  /**
   * Overridden from @ref QDropSite
   */
  virtual void dragLeaveEvent ( TQDragLeaveEvent* );

  /**
   * Overridden from @ref QDropSite
   */
  virtual void dropEvent ( TQDropEvent* );

  virtual bool eventFilter ( TQObject*, TQEvent* );

private:
  KIconLoader* mKIL;
  TQLabel* mLabel;
  bool mOpen;
  int mPixmapWidth;
  
signals:
  void undoAction (KSVAction*);
};

#endif
