/**
 * Released under the GNU General Public License, version 2.
 * 
 * Copyright (c) 2000 Peter Putzer <putzer@kde.org>
 */

#ifndef KSVLOOKANDFEEL_H
#define KSVLOOKANDFEEL_H
#include "lookandfeelconfig.h"

#include <tqfont.h>
class KSVLookAndFeel : public LookAndFeel
{ 
  Q_OBJECT
  
public:
  KSVLookAndFeel( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~KSVLookAndFeel();
  
  inline const TQFont& serviceFont() const { return mServiceFont; }
  inline const TQFont& numberFont() const { return mNumberFont; }
  
  void setServiceFont (const TQFont& font);
  void setNumberFont (const TQFont& font);

signals:
  void configChanged();

protected slots:
  void chooseServiceFont();
  void chooseNumberFont();
  void slotChanged();

private:
  TQFont mServiceFont;
  TQFont mNumberFont;
};

#endif // KSVLOOKANDFEEL_H
