/***************************************************************************
    begin                : Sun Oct 3 1999
    copyright            : (C) 1999 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqfileinfo.h>
#include <tqcombobox.h>
#include <tqstring.h>

#include <kapplication.h>
#include <klocale.h>
#include <kbuttonbox.h>

#include "ksvdraglist.h"
#include "ServiceDlg.h"

#define MIN_SIZE(A) A->setMinimumSize(A->sizeHint())

ServiceDlg::ServiceDlg (const TQString& action, const TQString& label,
						TQWidget* parent, const char* name)
  : KDialogBase (parent, name, false, action, Apply|Close, Apply, true)
{
  TQWidget* page = new TQWidget (this);

  TQBoxLayout* top = new TQVBoxLayout (page, 0, spacingHint());

  mServices = new TQComboBox (false, page);
  TQLabel* desc = new TQLabel(label, page);
  MIN_SIZE(desc);
  desc->setBuddy(mServices);
  MIN_SIZE(mServices);
  mServices->setMinimumWidth(mServices->minimumSize().width() * 2);

  TQBoxLayout* serv_layout = new TQHBoxLayout();
  top->addLayout (serv_layout);
  serv_layout->addWidget(desc);
  serv_layout->addWidget(mServices);
  
  setFixedSize (sizeHint());
}

ServiceDlg::~ServiceDlg()
{
}

void ServiceDlg::slotApply()
{
  emit doAction (mMapServices[mServices->currentText()]->filenameAndPath());
}

int ServiceDlg::count() const
{
  return mServices->count();
}

void ServiceDlg::resetChooser(KSVDragList* list, bool edit)
{
  mServices->clear();
  mMapServices.clear();

  if (!list)
    return;

  // initialize the combobox
  for (TQListViewItemIterator it (list); 
	   it.current();
	   ++it)
    {
      const KSVItem* item = static_cast<KSVItem*> (it.current());
	  
      TQFileInfo info (item->filenameAndPath());
      
      if (edit)
		{
		  if (info.isReadable())
			mServices->insertItem(item->label());
		  
		  mMapServices[item->label()] = item;
		}
      else
		{
		  if (info.isExecutable())
			mServices->insertItem(item->label());

		  mMapServices[item->label()] = item;
		}
    }
}

void ServiceDlg::show ()
{
  TQDialog::show ();

  emit display (true);
}

void ServiceDlg::hide ()
{
  TQDialog::hide ();

  emit display (false);
}

void ServiceDlg::toggle ()
{
  if (isHidden())
    show();
  else
    hide();
}

#include "ServiceDlg.moc"
