#ifndef RUNLEVEL_AUTH_ICON_H
#define RUNLEVEL_AUTH_ICON_H

// (c) 2000 Peter Putzer <putzer@kde.org>
#include <kauthicon.h>

class TQTimer;
class TQFileInfo;

class RunlevelAuthIcon : public KAuthIcon
{
  Q_OBJECT
  Q_PROPERTY (int refreshInterval READ refreshInterval WRITE setRefreshInterval)
    
public:
  RunlevelAuthIcon (const TQString& scriptPath, const TQString& runlevelPath,
					TQWidget* parent = 0L, const char* name = 0L);

  virtual ~RunlevelAuthIcon ();

  virtual bool status () const;

  inline int refreshInterval () const { return mInterval; }
  inline bool isCheckEnabled () const { return mCheckEnabled; }

public slots:
  virtual void updateStatus ();

  void setServicesPath (const TQString& servicesPath);
  void setRunlevelPath (const TQString& runlevelPath);

  void setRefreshInterval (int);

  void setCheckEnabled(bool);

private slots:
  void timerEvent ();

private:
  TQTimer* mTimer;
  TQFileInfo* mServicesInfo;
  TQFileInfo** mRLInfo;
  bool mOld;
  int mInterval;
  
  bool mCheckEnabled;
};

#endif // RUNLEVEL_AUTH_ICON_H
