// (c) 2000 Peter Putzer

#ifndef KSV_DATA_H
#define KSV_DATA_H

class TQDataStream;

class KSVData
{
public:
  KSVData ();
  KSVData (const TQString& file, const TQString& path, const TQString& label, Q_INT8 nr);
  KSVData (const KSVData& rhs);
  inline ~KSVData () {}

  const KSVData& operator= (const KSVData& rhs);
  bool operator== (const KSVData& rhs) const;
  bool operator< (const KSVData& rhs) const;

  inline TQString filenameAndPath () const { return mPath + "/" + mFilename; }

  inline const TQString& path () const { return mPath; }
  inline const TQString& label () const { return mLabel; }
  inline const TQString& filename () const { return mFilename; }
  inline const TQString& runlevel () const { return mRunlevel; }
  inline Q_INT8 number () const { return mNr; }

  inline const TQString& numberString () const { return mNumberString; }

  inline const TQString& oldLabel () const { return mOldLabel; }
  inline const TQString& oldFilename () const { return mOldFilename; }
  inline const TQString& originalRunlevel () const { return mOldFilename; }
  inline Q_INT8 oldNumber () const { return mOldNr; }
  
  inline bool numberChanged () const { return mNrChanged; }
  inline bool labelChanged () const { return mLabelChanged; }
  inline bool otherChanged () const { return mOtherChanged; }
  inline bool filenameChanged () const { return mFilenameChanged; }
  inline bool newEntry () const { return mNewEntry; }

  inline bool changed () const { return mNrChanged || mLabelChanged || mFilenameChanged; }

  inline void setNumberChanged (bool val) { mNrChanged = val; }
  inline void setNewEntry (bool val) { mNewEntry = val; }
  void setPath (const TQString&);
  void setLabel (const TQString&);
  void setFilename (const TQString&);
  void setRunlevel (const TQString&);
  void setOriginalRunlevel (const TQString&);
  void setNumber (Q_INT8 nr);
  void setChanged (bool);
 
private:
  friend TQDataStream& operator<< (TQDataStream&, const KSVData&);
  friend TQDataStream& operator>> (TQDataStream&, KSVData&);

  TQString mPath;
  TQString mLabel;
  TQString mFilename;
  TQString mRunlevel;
  Q_INT8 mNr;
  TQString mOldLabel;
  TQString mOldFilename;
  TQString mOriginalRunlevel;
  Q_INT8 mOldNr;
  
  bool mNrChanged;
  bool mLabelChanged;
  bool mOtherChanged;
  bool mFilenameChanged;
  bool mNewEntry;

  TQString mNumberString;
};

TQDataStream& operator<< (TQDataStream& stream, const KSVData& data);
TQDataStream& operator>> (TQDataStream& stream, KSVData& data);

#endif // KSV_DATA_H
