// (c) 2000 Peter Putzer

#include <tqdatastream.h>
#include <kdatastream.h>

#include "Data.h"

KSVData::KSVData ()
{
  mNrChanged = mLabelChanged = mFilenameChanged = mOtherChanged = mNewEntry = false;
  mNr = mOldNr = 0;
}

KSVData::KSVData (const TQString& file, const TQString& path,
                  const TQString& label, Q_INT8 nr)
  : mPath (path),
    mLabel (label), mFilename (file)
{
  mNrChanged = mLabelChanged = mFilenameChanged = mOtherChanged = mNewEntry = false;
  mNr = mOldNr = 0;
  setNumber (nr);
  mNrChanged = false;
}

KSVData::KSVData (const KSVData& rhs)
  : mPath (rhs.mPath),
    mLabel (rhs.mLabel),
    mFilename (rhs.mFilename),
    mRunlevel (rhs.mRunlevel),
    mNr (rhs.mNr),
    mOldLabel (rhs.mOldLabel),
    mOldFilename (rhs.mOldFilename),
    mOriginalRunlevel (rhs.mOriginalRunlevel),
    mOldNr (rhs.mOldNr),
    mNrChanged (rhs.mNrChanged),
    mLabelChanged (rhs.mLabelChanged),
    mOtherChanged (rhs.mOtherChanged),
    mFilenameChanged (rhs.mFilenameChanged),
    mNewEntry (rhs.mNewEntry), mNumberString (rhs.mNumberString)
{
}

const KSVData& KSVData::operator= (const KSVData& rhs)
{
  if (this ==&rhs)
    return *this;

  mPath = rhs.mPath;
  mLabel = rhs.mLabel;
  mFilename = rhs.mFilename;
  mRunlevel = rhs.mRunlevel;
  mNr = rhs.mNr;

  mOldLabel = rhs.mOldLabel;
  mOldFilename = rhs.mOldFilename;
  mOriginalRunlevel = rhs.mOriginalRunlevel;
  mOldNr = rhs.mOldNr;

  mNrChanged = rhs.mNrChanged;
  mLabelChanged = rhs.mLabelChanged;
  mOtherChanged = rhs.mOtherChanged;
  mFilenameChanged = rhs.mFilenameChanged;
  mNewEntry = rhs.mNewEntry;

  mNumberString = rhs.mNumberString;

  return *this;
}

bool KSVData::operator== (const KSVData& rhs) const
{
  return mLabel == rhs.mLabel &&
    mPath == rhs.mPath && mFilename == rhs.mFilename;
  //   return mPath == rhs.mPath &&
  //    mLabel == rhs.mLabel &&
  //    mFilename == rhs.mFilename &&
  //    mRunlevel == rhs.mRunlevel &&
  //    mNr == rhs.mNr &&

  //    mOldLabel == rhs.mOldLabel &&
  //    mOldFilename == rhs.mOldFilename &&
  //    mOriginalRunlevel == rhs.mOriginalRunlevel &&
  //    mOldNr == rhs.mOldNr &&

  //    mNrChanged == rhs.mNrChanged &&
  //    mLabelChanged == rhs.mLabelChanged &&
  //    mOtherChanged == rhs.mOtherChanged &&
  //    mFilenameChanged == rhs.mFilenameChanged &&
  //    mNewEntry == rhs.mNewEntry;
}

bool KSVData::operator< (const KSVData& rhs) const
{
  return mNr< rhs.mNr;
}

void KSVData::setPath (const TQString& s)
{
  if (mPath != s)
    mOtherChanged = true;

  mPath = s;
}

void KSVData::setLabel (const TQString& s)
{
  if (!mLabelChanged && mLabel != s)
    {
      mOldLabel = mLabel;
      mLabelChanged = true;
    }

  mLabel = s;
}

void KSVData::setFilename (const TQString& s)
{
  if (!mFilenameChanged && mFilename != s)
    {
      mOldFilename = mFilename;
      mFilenameChanged = true;
    }

  mFilename = s;
}

void KSVData::setRunlevel (const TQString& s)
{
  mRunlevel = s;
}

void KSVData::setNumber (Q_INT8 nr)
{
  if (!mNrChanged && mNr != nr)
    {
      mOldNr = mNr;
      mNrChanged = true;
    }

  mNr = nr;
  mNumberString.sprintf ("%.2i", nr);
}

void KSVData::setChanged (bool val)
{
  mNrChanged = mLabelChanged = mOtherChanged = mFilenameChanged = val;
}

void KSVData::setOriginalRunlevel (const TQString& rl)
{
  mOriginalRunlevel = rl;
}

TQDataStream& operator<< (TQDataStream& stream, const KSVData& data)
{
  return stream << data.mPath
                << data.mFilename
                << data.mNr
                << data.mRunlevel
                << data.mLabel
                << data.mOldFilename
                << data.mOldNr
                << data.mOldLabel
                << data.mNrChanged
                << data.mLabelChanged
                << data.mFilenameChanged
                << data.mOtherChanged << data.mOriginalRunlevel << data.mNewEntry;

}

TQDataStream& operator>> (TQDataStream& stream, KSVData& data)
{
  stream >> data.mPath
         >> data.mFilename
         >> data.mNr
         >> data.mRunlevel
         >> data.mLabel
         >> data.mOldFilename
         >> data.mOldNr
         >> data.mOldLabel
         >> data.mNrChanged
         >> data.mLabelChanged
         >> data.mFilenameChanged
         >> data.mOtherChanged >> data.mOriginalRunlevel >> data.mNewEntry;


  data.mNumberString.sprintf ("%.2i", data.mNr);

  return stream;
}
