/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/



#ifndef KPTERMD_H
#define KPTERMD_H

#include "../config.h"

#include <tqtextedit.h>
#include <tqstringlist.h>
#include <tqlayout.h>
#include <tqlabel.h>

#include <klocale.h>
#include <kdialogbase.h>
#include <kpackage.h>
#include <kpPty.h>

//////////////////////////////////////////////////////////////////////////////
class kpTerm: public QTextEdit
{ 
  Q_OBJECT

public:
  kpTerm(kpPty *pt, TQWidget * parent=0, const char * name=0);
  void keyPressEvent ( TQKeyEvent * e );
  bool run(const TQString &cmd, TQStringList &r);
  void doConnect();
  void doUnconnect();
  void insert ( const TQString & str, bool mark=FALSE );
  kpPty *pty;
  void cancel();
  void done();

public slots:
  void textIn(const TQString &, bool);
  void slotResult(TQStringList &, int);

signals:
  void keyOut(char);
  void result(TQStringList &, int);

};

//////////////////////////////////////////////////////////////////////////////

class kpRun: public KDialogBase
{
  Q_OBJECT

public:
  kpRun(TQWidget *parent = 0);
  bool run(TQString cmd, TQString title);
  void addText(const TQStringList &ret);

public slots:
  void slotResult(TQStringList &, int);
  void slotCancel();

private:
  kpTerm *term;
  TQLabel *title;
};	
//////////////////////////////////////////////////////////////////////////////
#endif
