/***************************************************************************
                          knetworkconfigparser.h  -  description
                             -------------------
    begin                : Mon Jan 13 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : jbaptiste@merlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKCONFIGPARSER_H
#define KNETWORKCONFIGPARSER_H

#define BACKEND_PATH "knetworkconf/backends/network-conf"
#define ETHERNET_IFACE_TYPE "ethernet"
#define WIRELESS_IFACE_TYPE "wireless"
#define LOOPBACK_IFACE_TYPE "loopback"

#define WIRELESS_WEP_KEY_TYPE_ASCII "ascii"
#define WIRELESS_WEP_KEY_TYPE_HEXADECIMAL "hexadecimal"

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <tqobject.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqstring.h>
#include <tqprocess.h>
#include <tqdom.h>
#include <tqlabel.h>
#include <tqcheckbox.h>

#include <klistbox.h>
#include <ksimpleconfig.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "knetworkinfo.h"
#include "kdetectdistrodlg.h"
#include "kreloadnetworkdlg.h"
#include "kinterfaceupdowndlg.h"
#include "kselectdistrodlg.h"

/**
  *@author Juan Luis Baptiste
  */

class KNetworkConfigParser : public TQObject {
  Q_OBJECT
  public:
    KNetworkConfigParser();
    ~KNetworkConfigParser();
    /** return tyhe number of configured devices. */
    unsigned numDevices();
    void setProgramVersion(TQString ver);
    /** Reads /proc/net/route looking for the default gateway. */
    void loadRoutingInfo(KRoutingInfo *routingInfo);
    /** Saves the new network configuration. */
    void saveNetworkInfo(KNetworkInfo *networkInfo);
    /** Loads the network info from a xml file generated by the gnome system tools
        network backends that are included with this app. */
    KNetworkInfo * getNetworkInfo();
    TQProcess * proc;
    TQProcess * procDetect;
    TQProcess * procSaveNetworkInfo;
    /** Variable to know if there is an dhcp device configured, so we can know if we need to save the defauilt gw info or not. */
    bool dhcpDevice;
    KNetworkInterface * getDeviceInfo(TQString device);


  public slots:
    /** runs gst to find out the state of network devices.It runs the command:
    $knetworkconf_home/backends/networkconf [--platform platform] -d list_ifaces */
    void listIfaces(const TQString &platform);

  private slots:
   /** Runs the gst backend to get network values. You can pass to the script a specific platform to load using the platform parameter.  */
    void runDetectionScript(TQString platform);  
    void readIfconfigOutput();
    void readNetworkInfo();
    void readFromStdoutReloadScript();
    /** emits a signal when the network changes have benn saved. */
    void sendNetworkInfoSavedSignalSlot();
    /** Concatenates into a TQString the xml output of the network backend. */
    void concatXMLOutputSlot();
    void readXMLErrSlot();
    /** Shows the dialog with all the supported platforms by GST. */
    void showSupportedPlatformsDialogSlot();
    /** Parses the xml ouput generated by GST that has all the supported platforms. */
    void readSupportedPlatformsSlot();
    /** No descriptions */
    void readListIfacesSlot();
    void readFromStdoutSaveNetworkInfo();
    /** Calls runDetectionScript(). */
    void listIfacesSlot();
    /** save process has exited */
    void processExitedSlot();
                
  private:
    //TQPtrList<KNetworkInterface> deviceList;
    TQPtrList<KNetworkInterface>  tempList;
    KNetworkInterface *newDevice;
    bool isUp;
    /** Counts the number of configured devices that had been found. */
    unsigned _numDevices;
    KRoutingInfo *routingInfo;
    KDNSInfo *dnsInfo;
    TQString programVersion;
    /**  The output of ifconfig command that needs to be parsed in readIfconfigOutput()*/
    TQString ifconfigOutput;
    KNetworkInfo * networkInfo;
    TQPtrList<KKnownHostInfo> knownHostsList;
    TQString hexIPv4ToDecIPv4(const TQString &hex);
    /** lists all platforms supported by GST. */
    void loadSupportedPlatforms();
    /** Returns the info of a platform in the form of 'key:value' . */
    TQString getPlatformInfo(TQDomElement platform);
    /** save process is running */
    bool processRunning;

    /** Shows a progress dialog while the networl is being reloaded. */
    KInterfaceUpDownDlg * kpdReloadStatusDlg;
    TQProcess *procReloadNetwork;
    TQString reloadScriptOutput;
    /** Contains the network configuration en xml format. */
    /** List of supported platforms. */
    TQStringList supportedPlatformsList;
    TQString xmlOuput;
    TQString xmlErr;
    /** Temporal device list to be used when loading the dhcp devices info */
    TQPtrList<KNetworkInterface> tempDevList;
    /** Parses all of the <statichost>...</statichost> entries in the xml configuration file. */
    KKnownHostInfo * getStaticHostInfo(TQDomElement host);
    /** Saves the option to show again or not the platform using KSimpleConfig*/
    void saveAskAgain(const TQString &platform, bool askAgain);
    /**Returns if the show platform should be shown again or not and the saved platform*/
    bool readAskAgain(TQString &platform);
    void parseNetworkInfo(TQDomNode node, KNetworkInfo *networkInfo, bool isProfile);
    void addRoutingInfoToXMLDoc(TQDomDocument *doc, TQDomNode *root, KRoutingInfo *routingInfo);
    void addDNSInfoToXMLDoc(TQDomDocument *doc, TQDomNode *root, KDNSInfo *dnsInfo);    
    void addNetworkInterfacesToXMLDoc(TQDomDocument *doc, TQDomNode *root, TQPtrList<KNetworkInterface> devList);
    void addNetworkProfilesToXMLDoc(TQDomDocument *doc, TQDomNode *root, TQPtrList<KNetworkInfo> profileList);
    
  protected: // Protected methods
    /** Parses all of the <interface>...</interface> entries in the xml configuration file. */
    virtual KNetworkInterface *getInterfaceInfo(TQDomElement interface, const TQString &type);
    /** Parses all of the <interface>...</interface> entries in the xml configuration file. Returns a KWirelessInterface 
    object that contains all the info of the wireless interface. */    
    virtual KWirelessInterface *getWirelessInterfaceInfo(TQDomElement interface, const TQString &type);

  signals: // Signals
    /** emmited when the xml file is finished reading. */
    void readyLoadingNetworkInfo();
    
    /** emmited when the xml file saved and the backend has finished executing. */
//    void readySavingNetworkInfo();
    
    /** Signal that is sent when fillDevices() has finished fllind the dhcp devices. */
    void readyIfconfigOutputSignal();
    /** Signal emmited when the platform can't be auto-detected. */
    void errorDetectingPlatform();
    /** signal emmited when the parsing of the xml of the supported platform list. */
    void readyLoadingSupportedPlatforms();
    /** signal emmited when the config parser needs to set read only the GUI because 
        some error in the parsing, or the platform isn't supported.*/
    void setReadOnly(bool);
};

#endif
