// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <unistd.h>

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqlistbox.h>

#include <kapplication.h>
#include <kfiledialog.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include "VerifyOptDlg.h"
#include <klocale.h>

#include "VerifyOptDlg.moc"

VerifyOptDlg::VerifyOptDlg( const TQString & def, const TQStringList& files, bool restore, TQWidget* parent, const char* name )
        : TQDialog( parent, name, TRUE ),
          _restore( restore )
{
    if ( _restore ) {
        setIconText( i18n( "KDat: Restore Options" ) );
        setCaption( i18n( "KDat: Restore Options" ) );
    } else {
        setIconText( i18n( "KDat: Verify Options" ) );
        setCaption( i18n( "KDat: Verify Options" ) );
    }

    TQLabel* lbl1;
    if ( _restore ) {
        lbl1 = new TQLabel( i18n( "Restore to folder:" ), this );
    } else {
        lbl1 = new TQLabel( i18n( "Verify in folder:" ), this );
    }
    lbl1->setFixedSize( lbl1->sizeHint() );

    _entry = new TQLineEdit( this );
    _entry->setText( def );
    _entry->setFixedHeight( _entry->sizeHint().height() );

    TQPushButton* browse = new TQPushButton( i18n( "..." ), this );
    browse->setFixedSize( browse->sizeHint() );

    TQLabel* lbl2;
    if ( _restore ) {
        lbl2 = new TQLabel( i18n( "Restore files:" ), this );
    } else {
        lbl2 = new TQLabel( i18n( "Verify files:" ), this );
    }
    lbl2->setFixedHeight( lbl2->sizeHint().height() );

    TQListBox* fileList = new TQListBox( this );
    fileList->insertStringList(files);

    KPushButton* ok     = new KPushButton( KStdGuiItem::ok(), this );
    ok->setFixedSize( 80, ok->sizeHint().height() );
    KPushButton* cancel = new KPushButton( KStdGuiItem::cancel(), this );
    cancel->setFixedSize( 80, cancel->sizeHint().height() );

    TQVBoxLayout* l1 = new TQVBoxLayout( this, 8, 4 );

    TQHBoxLayout* l1_1 = new TQHBoxLayout();
    l1->addLayout( l1_1 );
    l1_1->addWidget( lbl1 );
    l1_1->addWidget( _entry, 1 );
    l1_1->addWidget( browse );
    
    l1->addWidget( lbl2 );
    l1->addWidget( fileList, 1 );

    TQHBoxLayout* l1_2 = new TQHBoxLayout();
    l1->addLayout( l1_2, 0 );
    l1_2->addStretch( 1 );
    l1_2->addWidget( ok, 0 );
    l1_2->addWidget( cancel, 0 );

    resize( 400, 300 );

    _entry->setFocus();
    _entry->selectAll();

    connect( _entry, TQT_SIGNAL( returnPressed() ), this, TQT_SLOT( okClicked() ) );
    connect( browse, TQT_SIGNAL( clicked() )      , this, TQT_SLOT( slotBrowse() ) );
    connect( ok    , TQT_SIGNAL( clicked() )      , this, TQT_SLOT( okClicked() ) );
    connect( cancel, TQT_SIGNAL( clicked() )      , this, TQT_SLOT( reject() ) );
}

VerifyOptDlg::~VerifyOptDlg()
{
}

void VerifyOptDlg::okClicked()
{
    _workingDir = _entry->text();
    accept();
}

TQString VerifyOptDlg::getWorkingDirectory()
{
    return _workingDir;
}

void VerifyOptDlg::slotBrowse()
{
    TQString tmp;
    tmp = KFileDialog::getExistingDirectory( _entry->text() );
    if ( tmp.length() ) {
        _entry->setText( tmp );
    }
}
