// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqmultilineedit.h>

#include <kapplication.h>
#include <kfiledialog.h>

#include "LoggerWidget.h"
#include <klocale.h>
#include <kmessagebox.h>

#include "LoggerWidget.moc"

LoggerWidget::LoggerWidget( const TQString & title, TQWidget* parent, const char* name )
        : TQWidget( parent, name )
{
    TQLabel* lbl1 = new TQLabel( title, this );
    lbl1->setFixedHeight( lbl1->sizeHint().height() );

    _mle = new TQMultiLineEdit( this );
    _mle->setReadOnly( TRUE );

    TQVBoxLayout* l1 = new TQVBoxLayout( this, 0, 4 );
    l1->addWidget( lbl1 );
    l1->addWidget( _mle, 1 );
}

LoggerWidget::~LoggerWidget()
{
}

void LoggerWidget::append( const TQString & text )
{
    _mle->append( text );
    _mle->setCursorPosition( _mle->numLines(), 0 );
}

void LoggerWidget::save()
{
    TQString file = KFileDialog::getSaveFileName( TQString::null, TQString::null, this );
    if ( !file.isNull() ) {
        TQFile f( file );
        if ( f.exists() ) {
            int result = KMessageBox::warningContinueCancel( this,
		   i18n( "Log file exists, overwrite?" ),
                   i18n( "KDat: Save Log" ), 
                   i18n("&Overwrite"));
            if (result != KMessageBox::Continue)
                return;
        }
        if ( f.open( IO_WriteOnly ) ) {
            TQCString line;
            for ( int i = 0; i < _mle->numLines(); i++ ) {
                line = _mle->textLine( i ).utf8();
                f.writeBlock( line, line.length() );
                f.writeBlock( "\n", 1 );
            }
            f.close();
        }
    }
}
