/***************************************************************************
 *   Copyright (C) 1999, 2000 by Bernd Gehrmann                            *
 *   bernd@kdevelop.org                                                    *
 *   Modified for perforce 2002 by Harald Fernengel <harry@kdevelop.org>   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _COMMITDIALOG_H_
#define _COMMITDIALOG_H_

#include <tqstringlist.h>
#include <tqtextedit.h>
#include <klineedit.h>
#include <klistbox.h>
#include <kdialogbase.h>

class KProcess;

class CommitDialog : public KDialogBase
{
    Q_OBJECT
public:
    CommitDialog( TQWidget *parent = 0, const char *name = 0 );
    ~CommitDialog();

    TQString logMessage() const { return edit->text(); }
    TQString user() const { return userEdit->text(); }
    TQString client() const { return clientEdit->text(); }
    TQString changeList() const;
    
    void setUser( const TQString& usr ) { userEdit->setText( usr ); }
    void setClient( const TQString& clnt ) { clientEdit->setText( clnt ); }
    void setFiles( const TQStringList& lst ); 

    /** tries to fill out user and client */
    void autoGuess();    

protected slots:
    void accept();

private slots:
    void getFilesFinished( const TQString& out, const TQString& err );

private:
    void setDepotFiles( const TQStringList& lst );
    TQTextEdit *edit;
    KLineEdit *clientEdit, *userEdit;
    KListBox  *filesBox;
};

#endif

