/***************************************************************************
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlabel.h>
#include <klineedit.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>

#include "releaseinputdialog.h"

///////////////////////////////////////////////////////////////////////////////
// class ReleaseInputDialog
///////////////////////////////////////////////////////////////////////////////

ReleaseInputDialog::ReleaseInputDialog( TQWidget* parent)
    : ReleaseInputDialogBase( parent, "releaseinputdialog", true, 0 )
{
}

///////////////////////////////////////////////////////////////////////////////

ReleaseInputDialog::~ReleaseInputDialog()
{
}

///////////////////////////////////////////////////////////////////////////////

bool ReleaseInputDialog::isRevert() const
{
    return revertCheck->isChecked();
}

///////////////////////////////////////////////////////////////////////////////

TQString ReleaseInputDialog::release() const
{
    if (type() == byRevision)
        return " -r " + revisionEdit->text();
    else if (type() == byDate)
        return " -D " + dateEdit->text();
    else
        return TQString::null;
}

///////////////////////////////////////////////////////////////////////////////

ReleaseInputDialog::ReleaseType ReleaseInputDialog::type() const
{
    if (revisionRadio->isChecked())
        return byRevision;
    else if (dateRadio->isChecked())
        return byDate;
    else
        return byHead;
}

#include "releaseinputdialog.moc"

