/***************************************************************************
 *   Copyright (C) 200?-2003 by KDevelop Authors                           *
 *   www.kdevelop.org                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CVSLOGPAGE_H
#define CVSLOGPAGE_H

#include "cvsservicedcopIface.h"
#include <tqwidget.h>
#include "bufferedstringreader.h"

class CvsJob_stub;
class CvsService_stub;
class TQTextBrowser;

/**
Implementation for the form displaying 'cvs log' output.

@author KDevelop Authors
*/
class CVSLogPage : public TQWidget, virtual public CVSServiceDCOPIface
{
    Q_OBJECT
public:
    CVSLogPage( CvsService_stub *cvsService, TQWidget *parent=0, const char *name=0, int flags=0 );
    virtual ~CVSLogPage();

    void startLog( const TQString &workDir, const TQString &pathName );
    void cancel();

signals:
    // Emitted when the user click upon a link
    void diffRequested( const TQString &pathName, const TQString &revA, const TQString &revB );

private slots:
    void slotLinkClicked( const TQString &link );
    // DCOP Iface
    virtual void slotJobExited( bool normalExit, int exitStatus );
    virtual void slotReceivedOutput( TQString someOutput );
    virtual void slotReceivedErrors( TQString someErrors );

//private:
//    void parseLogContent( const TQString& text );

private:
    TQString m_pathName;
    TQTextBrowser *m_textBrowser;
    TQString m_logTextBackup;
	BufferedStringReader m_outputBuffer;
	TQStringList m_diffStrings;

    CvsService_stub *m_cvsService;
    CvsJob_stub *m_cvsLogJob;
};

#endif
