/***************************************************************************
 *   Copyright (C) 2003 by Ajay Guleria                                    *
 *   ajay_guleria at yahoo dot com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CLEARCASEPART_H_
#define _CLEARCASEPART_H_

#include <kdevversioncontrol.h>

class Context;
class TQPopupMenu;

class ClearcasePart : public KDevVersionControl {
    Q_OBJECT

public:
    ClearcasePart( TQObject *parent, const char *name, const TQStringList & );
    ~ClearcasePart();

    const TQString default_checkin;
    const TQString default_checkout;
    const TQString default_uncheckout;
    const TQString default_create;
    const TQString default_remove;
    const TQString default_lshistory;
    const TQString default_lscheckout;
    const TQString default_diff;

    virtual void createNewProject(const TQString& dir) {}
    virtual bool fetchFromRepository() { return true; }
    virtual KDevVCSFileInfoProvider *fileInfoProvider() const { return fileInfoProvider_; }
    virtual bool isValidDirectory(const TQString &dirPath) const;

private slots:
    void contextMenu(TQPopupMenu *popup, const Context *context);

    void slotCheckin();
    void slotCheckout();
    void slotUncheckout();

    void slotCreate();
    void slotRemove();
    void slotDiff();
    void slotDiffFinished( const TQString& diff, const TQString& err );
    void slotListHistory();
    void slotListCheckouts();


private:

    bool isValidCCDirectory_;
    TQString popupfile_;
    TQString viewname;

    KDevVCSFileInfoProvider *fileInfoProvider_;
};

#endif
