/***************************************************************************
 *   Copyright (C) 2002 by Yann Hodique                                    *
 *   Yann.Hodique@lifl.fr                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _GENERALINFOWIDGET_H_
#define _GENERALINFOWIDGET_H_

#include <tqwidget.h>
#include <tqdom.h>

#include "generalinfowidgetbase.h"

class TQDomDocument;

/**
General project information widget.
*/
class GeneralInfoWidget : public GeneralInfoWidgetBase {
    Q_OBJECT

public:

    GeneralInfoWidget(TQDomDocument &projectDom, TQWidget *parent=0, const char *name=0);
    ~GeneralInfoWidget();

public slots:
    void accept();

private slots:
    void slotProjectDirectoryChanged( const TQString& text );
    void slotProjectDirectoryComboChanged();

private:

    TQDomDocument m_projectDom;

    void readConfig();
    void writeConfig();

    bool isProjectDirectoryAbsolute();
    TQString projectDirectory();
    void setProjectDirectoryError( const TQString& error );
    void setProjectDirectorySuccess();
    void configureinUpdateVersion( TQString configureinpath, TQString newVersion );
};

#endif
