/*
 *  File : snippetitem.h
 *
 *  Author: Robert Gruber <rgruber@users.sourceforge.net>
 *
 *  Copyright: See COPYING file that comes with this distribution
 */

#ifndef SNIPPETITEM_H
#define SNIPPETITEM_H

#include <klistview.h>
#include <klocale.h>

class TQString;

class SnippetGroup;

/**
This class represents one CodeSnippet-Item in the listview.
It also holds the needed data for one snippet.
@author Robert Gruber
*/
class SnippetItem : public TQListViewItem {
friend class SnippetGroup;
public:
    SnippetItem(TQListViewItem * parent, TQString name, TQString text);

    ~SnippetItem();
    TQString getName();
    TQString getText();
    int getParent() { return iParent; }
    void resetParent();
    void setText(TQString text);
    void setName(TQString name);
    static SnippetItem * findItemByName(TQString name, TQPtrList<SnippetItem> &list);
    static SnippetGroup * findGroupById(int id, TQPtrList<SnippetItem> &list);
    
private:
  SnippetItem(TQListView * parent, TQString name, TQString text);
  TQString strName;
  TQString strText;
  int iParent;
};

/**
This class represents one group in the listview.
It is derived from SnippetItem in order to allow storing 
it in the main TQPtrList<SnippetItem>.
@author Robert Gruber
*/
class SnippetGroup : public SnippetItem {
public:
    SnippetGroup(TQListView * parent, TQString name, int id, TQString lang=i18n("All"));
    ~SnippetGroup();

    int getId() { return iId; }
    static int getMaxId() { return iMaxId; }
    TQString getLanguage() { return strLanguage; }
    
    void setId(int id);
    void setLanguage(TQString lang) { strLanguage = lang; }

private:
    static int iMaxId;
    int iId;
    TQString strLanguage;
};

#endif
