/***************************************************************************
 *   Copyright (C) 2003 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __REPLACEITEM_H__
#define __REPLACEITEM_H__


#include <kdeversion.h>
#include <kdebug.h>

#include "replaceview.h"

class ReplaceItem : public QCheckListItem
{
public:
    // the file item
    ReplaceItem( ReplaceView * parent, ReplaceItem * after, TQString file ) :
            TQCheckListItem( parent,
                            after,
                            file, TQCheckListItem::CheckBox ),
            _file( file ), _string( file ), _line( 0 ), _isfile( true ),
            _lineclicked( false ), _clicked( true )
    {
        setOpen( true );
        setOn( true );
    }

    // the line item
    ReplaceItem( ReplaceItem * parent, ReplaceItem * after, TQString file, TQString string, int line ) :
            TQCheckListItem( parent,
                            after,
                            TQString::number( line + 1 ) + ": " + string, TQCheckListItem::CheckBox ),
            _file( file ), _string( string ), _line( line ), _isfile( false ),
            _lineclicked( false ), _clicked( true )
    {
        setOn( true );
    }

    TQString const & file() const
    {
        return _file;
    }

    int line() const
    {
        return _line;
    }

    TQString const & string() const
    {
        return _string;
    }

    bool isFile() const
    {
        return _isfile;
    }

    bool justClicked()
    {
        bool t = _clicked;
        _clicked = true;
        return t;
    }

    bool lineClicked()
    {
        return _lineclicked;
    }

    ReplaceItem * parent() const
    {
        return static_cast<ReplaceItem*>( TQListViewItem::parent() );
    }

    ReplaceItem * firstChild() const
    {
        return static_cast<ReplaceItem*>( TQListViewItem::firstChild() );
    }

    ReplaceItem * nextSibling() const
    {
        return static_cast<ReplaceItem*>( TQListViewItem::nextSibling() );
    }

    void activate( int column, TQPoint const & localPos );
    bool hasCheckedChildren() const;
    virtual void stateChange( bool state );

    static bool s_listview_done;

private:
    void paintCell( TQPainter * p, const TQColorGroup & cg, int column, int width, int align );
    void setChecked( bool checked );

    TQString _file;
    TQString _string;
    int _line;
    bool const _isfile;
    bool _lineclicked;
    bool _clicked;
};

#endif

