/*
 *  Copyright (C) 2003 Roberto Raggi (roberto@kdevelop.org)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <kdevproject.h>
#include <kdevpartcontroller.h>


#include <klistbox.h>
#include <klocale.h>
#include <kdebug.h>
#include <kcompletion.h>
#include <klineedit.h>


#include <tqregexp.h>
#include <tqlabel.h>

#include "quickopenfiledialog.h"
#include "quickopen_part.h"

QuickOpenFileDialog::QuickOpenFileDialog(QuickOpenPart* part, TQWidget* parent, const char* name, bool modal, WFlags fl)
    : QuickOpenDialog( part, parent, name, modal, fl ), m_hasFullPaths( false )
{
    nameLabel->setText( i18n("File &name:") );
    itemListLabel->setText( i18n("File &list:") );

    m_items = m_part->project()->allFiles();

    nameEdit->setFocus();

    itemList->setSelectionMode( TQListBox::Extended );
    itemList->insertStringList( m_items );
    setFirstItemSelected();
}

QuickOpenFileDialog::QuickOpenFileDialog(QuickOpenPart* part, const KURL::List & urls, TQWidget* parent, const char* name, bool modal, WFlags fl)
    : QuickOpenDialog( part, parent, name, modal, fl ), m_hasFullPaths( true )
{
    nameLabel->setText( i18n("File &name:") );
    itemListLabel->setText( i18n("File &list:") );

    m_items = urls.toStringList();
    QStringList_unique( m_items );

    if (m_part->project())
    {
        for (unsigned int i = 0; i < m_items.count(); ++i)
        {
            TQString url = m_items[i];
            TQString projectUrl = "file://" + m_part->project()->projectDirectory();
            if (url.startsWith(projectUrl))
                m_items[i] = url.mid(projectUrl.length() + 1);
        }
    }

    nameEdit->setFocus();

    itemList->setSelectionMode( TQListBox::Extended );
    itemList->insertStringList( m_items );
    setFirstItemSelected();
}

QuickOpenFileDialog::~QuickOpenFileDialog()
{
}

void QuickOpenFileDialog::slotExecuted( TQListBoxItem* item )
{
    if ( !item ) return;

    if ( m_hasFullPaths )
    {
        m_part->partController()->editDocument( KURL::fromPathOrURL( item->text() ) );
    }
    else
    {
        m_part->partController()->editDocument( KURL::fromPathOrURL( m_part->project()->projectDirectory() + "/" + item->text() ) );
    }
    accept();
}

void QuickOpenFileDialog::slotReturnPressed( )
{
    maybeUpdateSelection();

    for (int i = 0; i < itemList->count(); ++i)
    {
        if (itemList->isSelected(i))
        {
            if (m_hasFullPaths)
            {
                m_part->partController()->editDocument(KURL::fromPathOrURL(itemList->item(i)->text()));
            }
            else
            {
                m_part->partController()->editDocument(KURL::fromPathOrURL(m_part->project()->projectDirectory() + "/" + itemList->item(i)->text()));
            }
        }
    }
    accept();
}

#include "quickopenfiledialog.moc"

