/***************************************************************************
 *   Copyright (C) 2003 by KDevelop authors                                *
 *   kdevelop-devel@kde.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _FILEVIEWPARTWIDGET_H_
#define _FILEVIEWPARTWIDGET_H_

#include <tqvbox.h>

class FileViewPart;

class PartWidget : public QVBox
{
    Q_OBJECT
public:
    PartWidget( FileViewPart *part, TQWidget *parent = 0 );
    virtual ~PartWidget();

    class FileTreeWidget *m_filetree;
    // Support for filters
    class KHistoryCombo *m_filter;
    class TQToolButton *m_btnFilter;

    void showProjectFiles();

protected:
    virtual void focusInEvent( TQFocusEvent * );

private slots:
    void slotFilterChange( const TQString & nf );
    void slotBtnFilterClick();

private:
    FileViewPart *m_part;
    TQString m_lastFilter;
};

#endif
