/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <kbuttonbox.h>
#include <klocale.h>
#include <kstdguiitem.h>
#include <kdeversion.h>

#include "addfilegroupdlg.h"


AddFileGroupDialog::AddFileGroupDialog(const TQString& old_title, const TQString& old_pattern, TQWidget *parent, const char *name)
    : TQDialog(parent, name, true)
{
    TQLabel *title_label = new TQLabel(i18n("&Title:"), this);
    title_edit = new KLineEdit(old_title, this);
    title_edit->setFocus();
    title_label->setBuddy(title_edit);
    connect( title_edit, TQT_SIGNAL( textChanged ( const TQString & ) ), this, TQT_SLOT( slotTextChanged() ) );

    TQLabel *pattern_label = new TQLabel(i18n("&Pattern:"), this);
    pattern_edit = new KLineEdit(old_pattern, this);
    pattern_label->setBuddy(pattern_edit);
    TQFontMetrics fm(pattern_edit->fontMetrics());
    pattern_edit->setMinimumWidth(fm.width('X')*35);
    connect( pattern_edit, TQT_SIGNAL( textChanged ( const TQString & ) ), this, TQT_SLOT( slotTextChanged() ) );
    TQVBoxLayout *layout = new TQVBoxLayout(this, 10);

    TQGridLayout *grid = new TQGridLayout(2, 2);
    layout->addLayout(grid);
    grid->addWidget(title_label, 0, 0);
    grid->addWidget(title_edit, 0, 1);
    grid->addWidget(pattern_label, 1, 0);
    grid->addWidget(pattern_edit, 1, 1);

    TQFrame *frame = new TQFrame(this);
    frame->setFrameStyle(TQFrame::HLine | TQFrame::Sunken);
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    m_pOk = buttonbox->addButton(KStdGuiItem::ok());
    TQPushButton *cancel = buttonbox->addButton(KStdGuiItem::cancel());

    m_pOk->setDefault(true);
    connect( m_pOk, TQT_SIGNAL(clicked()), this, TQT_SLOT(accept()) );
    connect( cancel, TQT_SIGNAL(clicked()), this, TQT_SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);
    slotTextChanged();
}


AddFileGroupDialog::~AddFileGroupDialog()
{}

void AddFileGroupDialog::slotTextChanged()
{
    m_pOk->setEnabled( !title_edit->text().isEmpty() && !pattern_edit->text().isEmpty() );
}

#include "addfilegroupdlg.moc"
