/***************************************************************************
 *   Copyright (C) 2005 by Jens Herden                                     *
 *   jens@kdewebdev.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef KDEVPROJECTVIEW_H
#define KDEVPROJECTVIEW_H

#include "fileinfo.h" 

#include <tqvaluelist.h>
#include <tqmap.h>
#include <tqguardedptr.h>

#include <kdevplugin.h>
#include <kurl.h>


class TQPopupMenu;
class KAction;
class KSelectAction;
class KDialogBase;
class Context;
class ConfigWidgetProxy;
class FileListWidget;
class KToolBar;
class TQVBox;
class ToolbarGUIBuilder;



/**
Please read the README.dox file for more info about this part

this is a reimplementation of the project views in Quanta

@TODO find a way to control the toolbar again
@TODO save html parts too
FIXME at project open I get the default view and the open files at last close
*/
class ProjectviewPart: public KDevPlugin
{
  Q_OBJECT
public:
 
  typedef TQMap<TQString, FileInfoList> ViewMap;
//   typedef TQMap<KURL, FileInfo> FileInfoMap;
  
  
  ProjectviewPart(TQObject *parent, const char *name, const TQStringList &args);
  ~ProjectviewPart();
  
  // reimplemented from KDevPlugin
  void restorePartialProjectSession(const TQDomElement * el);
  void savePartialProjectSession(TQDomElement * el);
  
  /**
  * 
  * @return the current defaut view
  */
  inline TQString getDefaultView() const {return m_defaultProjectView;};
  
  /**
  * 
  * @param view new default view
  */
  inline void setDefaultView(const TQString& view) {m_defaultProjectView = view;};
  
  /**
  * get all current views
  * @return TQStringList of defined views
  */
  inline TQStringList getViewList() const {return m_projectViews.keys();};

private slots:
  void init();
  
  void insertConfigWidget(const KDialogBase *dlg, TQWidget *page, unsigned int pageNo);
  void contextMenu(TQPopupMenu *popup, const Context *context);
  void projectOpened();
  void projectClosed();
  
  /** Deletes a project view
    *
    * @param view name of the project view
    */
  void slotDeleteProjectView(const TQString &view);
  
  /**
    * Deletes the current project view
    */
  void slotDeleteProjectViewCurent();

  /**
    * Saves a project view
    *
    * @param askForName true = show a dialog for the name
    */
  void slotSaveAsProjectView(bool askForName = true);
  
  /** Saves the current project view
    */
  void slotSaveProjectView();
  
  /** Opens a project view
    *
    * @param view name of the project view
    */
  void slotOpenProjectView(const TQString &view);
  
private:
  /**
    * create and initialize the actions
    */
  void setupActions();
  
  /**
  * Change the actions according to the current available views
  */
  void adjustViewActions();
  
  /**
   * write the views to the plugin config file
   */
  void writeConfig();

  /**
   * read the views from the plugin config file
   */
  void readConfig();

  ViewMap m_projectViews;  //container for the views
  
  KAction *m_savePrjViewAction;
  KAction *m_newPrjViewAction;
  KAction *m_deleteCurrentPrjViewAction;
  KSelectAction *m_openPrjViewAction;
  KSelectAction *m_deletePrjViewAction;
  
  TQString m_currentProjectView;
  TQString m_defaultProjectView;  // load this after project loaded
  
  KURL m_projectBase;  // project base folder
  ConfigWidgetProxy *m_configProxy;

  TQGuardedPtr<TQWidget> m_widget;
  TQGuardedPtr<ToolbarGUIBuilder> m_guibuilder;
  TQWidget * m_toolbarWidget;
  
  bool m_restored;
};


#endif
